/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.common.utils;

import android.text.TextUtils;
import android.util.Log;
import java.util.regex.Pattern;

public class SmartLog {
    private static final Pattern M_PATTERN = Pattern.compile("[0-9]*[a-z|A-Z]*[\u4e00-\u9fa5]*");
    private static final char STAR = '*';
    private static final int LEN_CONST = 2;

    private static String getLogMsg(String msg, boolean isNeedProguard) {
        StringBuilder retStr = new StringBuilder(512);
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            if (isNeedProguard) {
                retStr.append(SmartLog.formatLogWithStar(msg));
            } else {
                retStr.append(msg);
            }
        }
        return retStr.toString();
    }

    private static String getLogMsg(String noProguardMsg, String msg) {
        StringBuilder retStr = new StringBuilder(512);
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg)) {
            retStr.append(noProguardMsg);
        }
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            retStr.append(SmartLog.formatLogWithStar(msg));
        }
        return retStr.toString();
    }

    public static void d(String tag, String msg, boolean isNeedProguard) {
        if ("debug".equalsIgnoreCase("release") && !TextUtils.isEmpty((CharSequence)msg)) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard));
        }
    }

    public static void d(String tag, String noProguardMsg, String msg) {
        if (!(!"debug".equalsIgnoreCase("release") || TextUtils.isEmpty((CharSequence)noProguardMsg) && TextUtils.isEmpty((CharSequence)msg))) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg));
        }
    }

    public static void d(String tag, String noProguardMsg, String msg, Throwable e) {
        if (!(!"debug".equalsIgnoreCase("release") || TextUtils.isEmpty((CharSequence)noProguardMsg) && TextUtils.isEmpty((CharSequence)msg))) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void d(String tag, String msg) {
        if ("debug".equalsIgnoreCase("release") && !TextUtils.isEmpty((CharSequence)msg)) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(msg, false));
        }
    }

    public static void d(String tag, String msg, Throwable e, boolean isNeedProguard) {
        if ("debug".equalsIgnoreCase("release") && !TextUtils.isEmpty((CharSequence)msg)) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void d(String tag, String msg, Throwable e) {
        if ("debug".equalsIgnoreCase("release") && (!TextUtils.isEmpty((CharSequence)msg) || null != e)) {
            Log.d((String)tag, (String)SmartLog.getLogMsg(msg, false), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void i(String tag, String msg, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard));
        }
    }

    public static void i(String tag, String noProguardMsg, String msg) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg));
        }
    }

    public static void i(String tag, String noProguardMsg, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void i(String tag, String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(msg, false));
        }
    }

    public static void i(String tag, String msg, Throwable e, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void i(String tag, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.i((String)tag, (String)SmartLog.getLogMsg(msg, false), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void w(String tag, String msg, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard));
        }
    }

    public static void w(String tag, String noProguardMsg, String msg) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg));
        }
    }

    public static void w(String tag, String noProguardMsg, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void w(String tag, String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(msg, false));
        }
    }

    public static void w(String tag, String msg, Throwable e, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void w(String tag, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.w((String)tag, (String)SmartLog.getLogMsg(msg, false), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void e(String tag, String msg, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard));
        }
    }

    public static void e(String tag, String noProguardMsg, String msg) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg));
        }
    }

    public static void e(String tag, String noProguardMsg, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)noProguardMsg) || !TextUtils.isEmpty((CharSequence)msg)) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(noProguardMsg, msg), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void e(String tag, String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(msg, false));
        }
    }

    public static void e(String tag, String msg, Throwable e, boolean isNeedProguard) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(msg, isNeedProguard), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    public static void e(String tag, String msg, Throwable e) {
        if (!TextUtils.isEmpty((CharSequence)msg) || null != e) {
            Log.e((String)tag, (String)SmartLog.getLogMsg(msg, false), (Throwable)SmartLog.getNewThrowable(e));
        }
    }

    private static String formatLogWithStar(String logStr) {
        if (TextUtils.isEmpty((CharSequence)logStr)) {
            return logStr;
        }
        int len = logStr.length();
        if (1 == len) {
            return String.valueOf('*');
        }
        StringBuilder retStr = new StringBuilder(len);
        int k = 1;
        for (int i = 0; i < len; ++i) {
            int charAt = logStr.charAt(i);
            if (M_PATTERN.matcher(String.valueOf((char)charAt)).matches()) {
                if (k % 2 == 0) {
                    charAt = 42;
                }
                ++k;
            }
            retStr.append((char)charAt);
        }
        return retStr.toString();
    }

    private static Throwable getNewThrowable(Throwable e) {
        if (e == null) {
            return null;
        }
        ThrowableWrapper retWrapper = new ThrowableWrapper(e);
        retWrapper.setStackTrace(e.getStackTrace());
        retWrapper.setMessage(SmartLog.modifyExceptionMessage(e.getMessage()));
        ThrowableWrapper preWrapper = retWrapper;
        for (Throwable currThrowable = e.getCause(); currThrowable != null; currThrowable = currThrowable.getCause()) {
            ThrowableWrapper currWrapper = new ThrowableWrapper(currThrowable);
            currWrapper.setStackTrace(currThrowable.getStackTrace());
            currWrapper.setMessage(SmartLog.modifyExceptionMessage(currThrowable.getMessage()));
            preWrapper.setCause(currWrapper);
            preWrapper = currWrapper;
        }
        return retWrapper;
    }

    private static String modifyExceptionMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        char[] messageChars = message.toCharArray();
        for (int i = 0; i < messageChars.length; ++i) {
            if (i % 2 != 0) continue;
            messageChars[i] = 42;
        }
        return new String(messageChars);
    }

    private static class ThrowableWrapper
    extends Throwable {
        private static final long serialVersionUID = 7129050843360571879L;
        private String message;
        private Throwable thisCause;
        private Throwable ownerThrowable;

        public ThrowableWrapper(Throwable t) {
            this.ownerThrowable = t;
        }

        @Override
        public Throwable getCause() {
            return this.thisCause == this ? null : this.thisCause;
        }

        public void setCause(Throwable cause) {
            this.thisCause = cause;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public String toString() {
            if (this.ownerThrowable == null) {
                return "";
            }
            String throwableClzName = this.ownerThrowable.getClass().getName();
            if (this.message != null) {
                String prefix = throwableClzName + ": ";
                return this.message.startsWith(prefix) ? this.message : prefix + this.message;
            }
            return throwableClzName;
        }
    }
}

