/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.common.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class ImageConvertUtils {
    public static final int INDEX_PLANE_Y = 0;
    public static final int INDEX_PLANE_U = 1;
    public static final int INDEX_PLANE_V = 2;
    public static final int YUV_FORMAT_I420 = 1;
    public static final int YUV_FORMAT_NV21 = 2;
    private static final ImageConvertUtils INSTANCE = new ImageConvertUtils();

    private ImageConvertUtils() {
    }

    public static ImageConvertUtils getInstance() {
        return INSTANCE;
    }

    public static byte[] buffer2Byte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byte[] bytes = new byte[byteBuffer.limit()];
        byteBuffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] nv21ToJpeg(byte[] nv21Bytes, int width, int height) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            YuvImage yuvImage = new YuvImage(nv21Bytes, 17, width, height, null);
            yuvImage.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] bitmap2Jpeg(Bitmap bitmap, int quality) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public static byte[] yuv2Buffer(Image image) {
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer yBuffer = planes[0].getBuffer();
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int ySize = yBuffer.remaining();
        int uSize = uBuffer.remaining();
        int vSize = vBuffer.remaining();
        int yuvSize = ySize + uSize + vSize;
        byte[] nv21 = new byte[yuvSize];
        yBuffer.get(nv21, 0, ySize);
        vBuffer.get(nv21, ySize, vSize);
        uBuffer.get(nv21, yuvSize - uSize, uSize);
        return nv21;
    }

    public static byte[] byteToNv21(byte[] bytes) {
        int length = bytes.length;
        int yLength = length * 2 / 3;
        int vuLength = length - yLength;
        int rowStride = length / 6;
        byte[] nv21 = new byte[length];
        System.arraycopy(bytes, 0, nv21, 0, yLength);
        for (int i = 0; i < vuLength; ++i) {
            nv21[yLength + i] = i % 2 == 0 ? bytes[yLength + i / 2] : bytes[yLength + rowStride + i / 2];
        }
        return nv21;
    }

    public static byte[] bitmapToNv21(Bitmap src, int width, int height) {
        if (src != null && src.getWidth() >= width && src.getHeight() >= height) {
            int[] argb = new int[width * height];
            src.getPixels(argb, 0, width, 0, 0, width, height);
            return ImageConvertUtils.argbToNv21(argb, width, height);
        }
        return new byte[0];
    }

    private static byte[] argbToNv21(int[] argb, int width, int height) {
        int frameSize = width * height;
        int yIndex = 0;
        int uvIndex = frameSize;
        int index = 0;
        byte[] nv21 = new byte[width * height * 3 / 2];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int r = (argb[index] & 0xFF0000) >> 16;
                int g = (argb[index] & 0xFF00) >> 8;
                int b = argb[index] & 0xFF;
                int y = (66 * r + 129 * g + 25 * b + 128 >> 8) + 16;
                int u = (-38 * r - 74 * g + 112 * b + 128 >> 8) + 128;
                int v = (112 * r - 94 * g - 18 * b + 128 >> 8) + 128;
                nv21[yIndex++] = (byte)(y < 0 ? 0 : (y > 255 ? 255 : y));
                if (j % 2 == 0 && index % 2 == 0 && uvIndex < nv21.length - 2) {
                    nv21[uvIndex++] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                    nv21[uvIndex++] = (byte)(u < 0 ? 0 : (u > 255 ? 255 : u));
                }
                ++index;
            }
        }
        return nv21;
    }

    public static byte[] nv21ToGray(byte[] nv21, int width, int height) {
        byte grayByte = -128;
        byte[] masks = new byte[width * height / 2];
        Arrays.fill(masks, grayByte);
        System.arraycopy(masks, 0, nv21, width * height, masks.length);
        return nv21;
    }

    private static boolean isImageFormatSupported(Image image) {
        int format = image.getFormat();
        return format == 35 || format == 17 || format == 842094169;
    }

    @TargetApi(value=21)
    public static byte[] getDataFromImage(Image image, int colorFormat) {
        ImageConvertUtils.checkFormat(image, colorFormat);
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        for (int i = 0; i < planes.length; ++i) {
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int channelOffset = ImageConvertUtils.getChannelOffset(i, colorFormat, width * height);
            int outputStride = ImageConvertUtils.getOutputStride(i, colorFormat);
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            int newPosition = rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift);
            buffer.position(newPosition);
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride != 1 || outputStride != 1) {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                } else {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    private static void checkFormat(Image image, int colorFormat) {
        if (colorFormat != 1 && colorFormat != 2) {
            throw new IllegalArgumentException("only support YUV_FORMAT_I420 and YUV_FORMAT_NV21");
        }
        if (!ImageConvertUtils.isImageFormatSupported(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
    }

    private static int getChannelOffset(int indexPlane, int colorFormat, int frameSize) {
        int channelOffset;
        switch (indexPlane) {
            case 0: {
                channelOffset = 0;
                break;
            }
            case 1: {
                channelOffset = colorFormat == 1 ? frameSize : frameSize + 1;
                break;
            }
            default: {
                channelOffset = colorFormat == 1 ? (int)((double)frameSize * 1.25) : frameSize;
            }
        }
        return channelOffset;
    }

    private static int getOutputStride(int indexPlane, int colorFormat) {
        int outputStride = indexPlane == 0 ? 1 : (colorFormat == 1 ? 1 : 2);
        return outputStride;
    }
}

