/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.common.utils;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.huawei.hms.ml.common.utils.SmartLog;
import java.lang.ref.WeakReference;

public final class ActivityMgr
implements Application.ActivityLifecycleCallbacks {
    public static final ActivityMgr INST = new ActivityMgr();
    private WeakReference<Activity> activity;

    private ActivityMgr() {
    }

    public void init(Application application) {
        if (application == null) {
            SmartLog.w("ActivityMgr", "init failed for app is null");
        } else {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)INST);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)INST);
        }
    }

    public Activity getCurrentActivity() {
        return this.activity == null ? null : (Activity)this.activity.get();
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        SmartLog.d("ActivityMgr", "onCreated:" + ActivityMgr.toString(activity));
        this.activity = new WeakReference<Activity>(activity);
    }

    public void onActivityStarted(Activity activity) {
        SmartLog.d("ActivityMgr", "onStarted:" + ActivityMgr.toString(activity));
        this.activity = new WeakReference<Activity>(activity);
    }

    public void onActivityResumed(Activity activity) {
        SmartLog.d("ActivityMgr", "onResumed:" + ActivityMgr.toString(activity));
        this.activity = new WeakReference<Activity>(activity);
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private static String toString(Object var0) {
        return var0 == null ? "null" : var0.getClass().getName() + '@' + Integer.toHexString(var0.hashCode());
    }
}

