/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.restful;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hankcs.hanlp.restful.CoreferenceResolutionOutput;
import com.hankcs.hanlp.restful.DocumentInput;
import com.hankcs.hanlp.restful.SentenceInput;
import com.hankcs.hanlp.restful.Span;
import com.hankcs.hanlp.restful.TokenInput;
import com.hankcs.hanlp.restful.mrp.MeaningRepresentation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HanLPClient {
    private String url;
    private String auth;
    private String language;
    private int timeout;
    private ObjectMapper mapper;

    public HanLPClient(String url, String auth, String language, int timeout) {
        if (auth == null) {
            auth = System.getenv().getOrDefault("HANLP_AUTH", null);
        }
        this.url = url;
        this.auth = auth;
        this.language = language;
        this.timeout = timeout * 1000;
        this.mapper = new ObjectMapper();
    }

    public HanLPClient(String url, String auth) {
        this(url, auth, null, 5);
    }

    public Map<String, List> parse(String text, String[] tasks, String[] skipTasks) throws IOException {
        return (Map)this.mapper.readValue(this.post("/parse", new DocumentInput(text, tasks, skipTasks, this.language)), Map.class);
    }

    public Map<String, List> parse(String text) throws IOException {
        return this.parse(text, null, null);
    }

    public Map<String, List> parse(String[] sentences, String[] tasks, String[] skipTasks) throws IOException {
        return (Map)this.mapper.readValue(this.post("/parse", new SentenceInput(sentences, tasks, skipTasks, this.language)), Map.class);
    }

    public Map<String, List> parse(String[] sentences) throws IOException {
        return this.parse(sentences, null, null);
    }

    public Map<String, List> parse(String[][] tokens, String[] tasks, String[] skipTasks) throws IOException {
        return (Map)this.mapper.readValue(this.post("/parse", new TokenInput(tokens, tasks, skipTasks, this.language)), Map.class);
    }

    public Map<String, List> parse(String[][] tokens) throws IOException {
        return this.parse(tokens, null, null);
    }

    public List<List<String>> tokenize(String text, Boolean coarse) throws IOException {
        String[] tasks = coarse != null ? (coarse.booleanValue() ? new String[]{"tok/coarse"} : new String[]{"tok/fine"}) : new String[]{"tok"};
        Map<String, List> doc = this.parse(text, tasks, null);
        return doc.values().iterator().next();
    }

    public List<List<String>> tokenize(String text) throws IOException {
        return this.tokenize(text, null);
    }

    public List<String> textStyleTransfer(List<String> text, String targetStyle) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("target_style", targetStyle);
        input.put("language", this.language);
        return (List)this.mapper.readValue(this.post("/text_style_transfer", input), List.class);
    }

    public String textStyleTransfer(String text, String targetStyle) throws IOException {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("text", text);
        input.put("target_style", targetStyle);
        input.put("language", this.language);
        return (String)this.mapper.readValue(this.post("/text_style_transfer", input), String.class);
    }

    public List<String> grammaticalErrorCorrection(List<String> text) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("language", this.language);
        return (List)this.mapper.readValue(this.post("/grammatical_error_correction", input), List.class);
    }

    public String[] grammaticalErrorCorrection(String[] text) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("language", this.language);
        return (String[])this.mapper.readValue(this.post("/grammatical_error_correction", input), String[].class);
    }

    public String grammaticalErrorCorrection(String text) throws IOException {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("text", text);
        input.put("language", this.language);
        return (String)this.mapper.readValue(this.post("/grammatical_error_correction", input), String.class);
    }

    public Float semanticTextualSimilarity(String textA, String textB) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", new String[]{textA, textB});
        input.put("language", this.language);
        return (Float)this.mapper.readValue(this.post("/semantic_textual_similarity", input), Float.class);
    }

    public List<Float> semanticTextualSimilarity(String[][] text) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("language", this.language);
        return (List)this.mapper.readValue(this.post("/semantic_textual_similarity", input), List.class);
    }

    public CoreferenceResolutionOutput coreferenceResolution(String text) throws IOException {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("text", text);
        input.put("language", this.language);
        Map response = (Map)this.mapper.readValue(this.post("/coreference_resolution", input), Map.class);
        List clusters = (List)response.get("clusters");
        return new CoreferenceResolutionOutput(HanLPClient._convert_clusters(clusters), (ArrayList)response.get("tokens"));
    }

    public List<Set<Span>> coreferenceResolution(String[][] tokens, String[] speakers) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("tokens", tokens);
        input.put("speakers", speakers);
        input.put("language", this.language);
        List clusters = (List)this.mapper.readValue(this.post("/coreference_resolution", input), List.class);
        return HanLPClient._convert_clusters(clusters);
    }

    public List<Set<Span>> coreferenceResolution(String[][] tokens) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("tokens", tokens);
        input.put("language", this.language);
        List clusters = (List)this.mapper.readValue(this.post("/coreference_resolution", input), List.class);
        return HanLPClient._convert_clusters(clusters);
    }

    private static List<Set<Span>> _convert_clusters(List<List<List>> clusters) {
        ArrayList<Set<Span>> results = new ArrayList<Set<Span>>(clusters.size());
        for (List<List> cluster : clusters) {
            LinkedHashSet<Span> spans = new LinkedHashSet<Span>();
            for (List span : cluster) {
                spans.add(new Span((String)span.get(0), (Integer)span.get(1), (Integer)span.get(2)));
            }
            results.add(spans);
        }
        return results;
    }

    public MeaningRepresentation[] abstractMeaningRepresentation(String text) throws IOException {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("text", text);
        input.put("language", this.language);
        return (MeaningRepresentation[])this.mapper.readValue(this.post("/abstract_meaning_representation", input), MeaningRepresentation[].class);
    }

    public MeaningRepresentation[] abstractMeaningRepresentation(String[][] tokens) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("tokens", tokens);
        input.put("language", this.language);
        return (MeaningRepresentation[])this.mapper.readValue(this.post("/abstract_meaning_representation", input), MeaningRepresentation[].class);
    }

    public Map<String, Double> keyphraseExtraction(String text, int topk) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("topk", topk);
        input.put("language", this.language);
        return (Map)this.mapper.readValue(this.post("/keyphrase_extraction", input), LinkedHashMap.class);
    }

    public Map<String, Double> extractiveSummarization(String text) throws IOException {
        return this.extractiveSummarization(text, 3);
    }

    public Map<String, Double> extractiveSummarization(String text, int topk) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("topk", topk);
        input.put("language", this.language);
        return (Map)this.mapper.readValue(this.post("/extractive_summarization", input), LinkedHashMap.class);
    }

    public String textClassification(String text, String model) throws IOException {
        return (String)this.textClassification(text, model, false, false);
    }

    public Object textClassification(Object text, String model, Object topk, boolean prob) throws IOException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("text", text);
        input.put("model", model);
        input.put("topk", topk);
        input.put("prob", prob);
        return this.mapper.readValue(this.post("/text_classification", input), Object.class);
    }

    public String languageIdentification(String text) throws IOException {
        return this.textClassification(text, "lid");
    }

    public List<String> languageIdentification(String[] text) throws IOException {
        return (List)this.textClassification(text, "lid", false, false);
    }

    public Map<String, Double> keyphraseExtraction(String text) throws IOException {
        return this.keyphraseExtraction(text, 10);
    }

    private String post(String api, Object input_) throws IOException {
        BufferedReader br;
        StringBuilder response;
        URL url = new URL(this.url + api);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        if (this.auth != null) {
            con.setRequestProperty("Authorization", "Basic " + this.auth);
        }
        con.setRequestProperty("Content-Type", "application/json; utf-8");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        con.setConnectTimeout(this.timeout);
        con.setReadTimeout(this.timeout);
        String jsonInputString = this.mapper.writeValueAsString(input_);
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int code = con.getResponseCode();
        if (code != 200) {
            response = new StringBuilder();
            br = new BufferedReader(new InputStreamReader(con.getErrorStream(), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                String responseLine;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
            }
            catch (Throwable responseLine) {
                throwable = responseLine;
                throw responseLine;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable responseLine) {
                            throwable.addSuppressed(responseLine);
                        }
                    } else {
                        br.close();
                    }
                }
            }
            String error = String.format("Request failed, status code = %d, error = %s", code, con.getResponseMessage());
            try {
                Map detail = (Map)this.mapper.readValue(response.toString(), Map.class);
                error = (String)detail.get("detail");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(error);
        }
        response = new StringBuilder();
        br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (br != null) {
                if (throwable != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    br.close();
                }
            }
        }
        return response.toString();
    }
}

