/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class SimplifiedToTaiwanChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToTraditionalTaiwanChinese(String simplifiedChineseString) {
        return SimplifiedToTaiwanChineseDictionary.segLongest(simplifiedChineseString.toCharArray(), trie);
    }

    public static String convertToTraditionalTaiwanChinese(char[] simplifiedChinese) {
        return SimplifiedToTaiwanChineseDictionary.segLongest(simplifiedChinese, trie);
    }

    static {
        long start = System.currentTimeMillis();
        String datPath = HanLP.Config.tcDictionaryRoot + "s2tw";
        if (!SimplifiedToTaiwanChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> s2t = new TreeMap<String, String>();
            TreeMap<String, String> t2tw = new TreeMap<String, String>();
            if (!SimplifiedToTaiwanChineseDictionary.load(s2t, false, HanLP.Config.tcDictionaryRoot + "s2t.txt") || !SimplifiedToTaiwanChineseDictionary.load(t2tw, false, HanLP.Config.tcDictionaryRoot + "t2tw.txt")) {
                throw new IllegalArgumentException("\u7b80\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            }
            SimplifiedToTaiwanChineseDictionary.combineChain(s2t, t2tw);
            trie.build(s2t);
            SimplifiedToTaiwanChineseDictionary.saveDat(datPath, trie, s2t.entrySet());
        }
        Predefine.logger.info("\u7b80\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

