/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.BeanResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.OperatorOverloader;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.PropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeLocator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveConstructorResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveMethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.StandardOperatorOverloader;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.StandardTypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.StandardTypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.StandardTypeLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StandardEvaluationContext
implements EvaluationContext {
    private TypedValue rootObject;
    private volatile List<PropertyAccessor> propertyAccessors;
    private volatile List<ConstructorResolver> constructorResolvers;
    private volatile List<MethodResolver> methodResolvers;
    private volatile ReflectiveMethodResolver reflectiveMethodResolver;
    private BeanResolver beanResolver;
    private TypeLocator typeLocator;
    private TypeConverter typeConverter;
    private TypeComparator typeComparator = new StandardTypeComparator();
    private OperatorOverloader operatorOverloader = new StandardOperatorOverloader();
    private final Map<String, Object> variables = new ConcurrentHashMap<String, Object>();

    public StandardEvaluationContext() {
        this.rootObject = TypedValue.NULL;
    }

    @Override
    public List<PropertyAccessor> getPropertyAccessors() {
        return this.initPropertyAccessors();
    }

    @Override
    public List<ConstructorResolver> getConstructorResolvers() {
        return this.initConstructorResolvers();
    }

    @Override
    public List<MethodResolver> getMethodResolvers() {
        return this.initMethodResolvers();
    }

    @Override
    public BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    @Override
    public TypeLocator getTypeLocator() {
        if (this.typeLocator == null) {
            this.typeLocator = new StandardTypeLocator();
        }
        return this.typeLocator;
    }

    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new StandardTypeConverter();
        }
        return this.typeConverter;
    }

    @Override
    public TypeComparator getTypeComparator() {
        return this.typeComparator;
    }

    @Override
    public OperatorOverloader getOperatorOverloader() {
        return this.operatorOverloader;
    }

    @Override
    public void setVariable(String name, Object value) {
        if (name != null) {
            if (value != null) {
                this.variables.put(name, value);
            } else {
                this.variables.remove(name);
            }
        }
    }

    @Override
    public Object lookupVariable(String name) {
        return this.variables.get(name);
    }

    private List<PropertyAccessor> initPropertyAccessors() {
        List<PropertyAccessor> accessors = this.propertyAccessors;
        if (accessors == null) {
            accessors = new ArrayList<PropertyAccessor>(5);
            accessors.add(new ReflectivePropertyAccessor());
            this.propertyAccessors = accessors;
        }
        return accessors;
    }

    private List<ConstructorResolver> initConstructorResolvers() {
        List<ConstructorResolver> resolvers = this.constructorResolvers;
        if (resolvers == null) {
            resolvers = new ArrayList<ConstructorResolver>(1);
            resolvers.add(new ReflectiveConstructorResolver());
            this.constructorResolvers = resolvers;
        }
        return resolvers;
    }

    private List<MethodResolver> initMethodResolvers() {
        List<MethodResolver> resolvers = this.methodResolvers;
        if (resolvers == null) {
            resolvers = new ArrayList<MethodResolver>(1);
            this.reflectiveMethodResolver = new ReflectiveMethodResolver();
            resolvers.add(this.reflectiveMethodResolver);
            this.methodResolvers = resolvers;
        }
        return resolvers;
    }
}

