/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParserContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.TemplateAwareExpressionParser;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.InternalParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Assign;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.BeanReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.BooleanLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.CompoundExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ConstructorReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Elvis;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FunctionReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Identifier;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Indexer;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineList;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineMap;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.MethodReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.NullLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpAnd;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpDec;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpDivide;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpEQ;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpGE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpGT;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpInc;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpLE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpLT;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpMinus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpModulus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpMultiply;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpNE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpOr;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpPlus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorBetween;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorInstanceof;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorMatches;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorNot;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorPower;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Projection;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.PropertyOrFieldReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.QualifiedIdentifier;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Selection;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.StringLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Ternary;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.VariableReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.SpelExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.Token;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.TokenKind;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.Tokenizer;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;

class InternalSpelExpressionParser
extends TemplateAwareExpressionParser {
    private static final Pattern VALID_QUALIFIED_ID_PATTERN = Pattern.compile("[\\p{L}\\p{N}_$]+");
    private final SpelParserConfiguration configuration;
    private final Deque<SpelNodeImpl> constructedNodes = new ArrayDeque<SpelNodeImpl>();
    private String expressionString = "";
    private List<Token> tokenStream = Collections.emptyList();
    private int tokenStreamLength;
    private int tokenStreamPointer;

    public InternalSpelExpressionParser(SpelParserConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected SpelExpression doParseExpression(String expressionString, ParserContext context) throws ParseException {
        try {
            this.expressionString = expressionString;
            Tokenizer tokenizer = new Tokenizer(expressionString);
            this.tokenStream = tokenizer.process();
            this.tokenStreamLength = this.tokenStream.size();
            this.tokenStreamPointer = 0;
            this.constructedNodes.clear();
            SpelNodeImpl ast = this.eatExpression();
            Assert.state(ast != null, "No node");
            Token t2 = this.peekToken();
            if (t2 != null) {
                throw new SpelParseException(t2.startPos, SpelMessage.MORE_INPUT, this.toString(this.nextToken()));
            }
            Assert.isTrue(this.constructedNodes.isEmpty(), "At least one node expected");
            return new SpelExpression(expressionString, ast, this.configuration);
        }
        catch (InternalParseException ex) {
            throw ex.getCause();
        }
    }

    private SpelNodeImpl eatExpression() {
        SpelNodeImpl expr = this.eatLogicalOrExpression();
        Token t2 = this.peekToken();
        if (t2 != null) {
            if (t2.kind == TokenKind.ASSIGN) {
                if (expr == null) {
                    expr = new NullLiteral(t2.startPos - 1, t2.endPos - 1);
                }
                this.nextToken();
                SpelNodeImpl assignedValue = this.eatLogicalOrExpression();
                return new Assign(t2.startPos, t2.endPos, expr, assignedValue);
            }
            if (t2.kind == TokenKind.ELVIS) {
                if (expr == null) {
                    expr = new NullLiteral(t2.startPos - 1, t2.endPos - 2);
                }
                this.nextToken();
                SpelNodeImpl valueIfNull = this.eatExpression();
                if (valueIfNull == null) {
                    valueIfNull = new NullLiteral(t2.startPos + 1, t2.endPos + 1);
                }
                return new Elvis(t2.startPos, t2.endPos, expr, valueIfNull);
            }
            if (t2.kind == TokenKind.QMARK) {
                if (expr == null) {
                    expr = new NullLiteral(t2.startPos - 1, t2.endPos - 1);
                }
                this.nextToken();
                SpelNodeImpl ifTrueExprValue = this.eatExpression();
                this.eatToken(TokenKind.COLON);
                SpelNodeImpl ifFalseExprValue = this.eatExpression();
                return new Ternary(t2.startPos, t2.endPos, expr, ifTrueExprValue, ifFalseExprValue);
            }
        }
        return expr;
    }

    private SpelNodeImpl eatLogicalOrExpression() {
        SpelNodeImpl expr = this.eatLogicalAndExpression();
        while (this.peekIdentifierToken("or") || this.peekToken(TokenKind.SYMBOLIC_OR)) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatLogicalAndExpression();
            this.checkOperands(t2, expr, rhExpr);
            expr = new OpOr(t2.startPos, t2.endPos, expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatLogicalAndExpression() {
        SpelNodeImpl expr = this.eatRelationalExpression();
        while (this.peekIdentifierToken("and") || this.peekToken(TokenKind.SYMBOLIC_AND)) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatRelationalExpression();
            this.checkOperands(t2, expr, rhExpr);
            expr = new OpAnd(t2.startPos, t2.endPos, expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatRelationalExpression() {
        SpelNodeImpl expr = this.eatSumExpression();
        Token relationalOperatorToken = this.maybeEatRelationalOperator();
        if (relationalOperatorToken != null) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatSumExpression();
            this.checkOperands(t2, expr, rhExpr);
            TokenKind tk = relationalOperatorToken.kind;
            if (relationalOperatorToken.isNumericRelationalOperator()) {
                if (tk == TokenKind.GT) {
                    return new OpGT(t2.startPos, t2.endPos, expr, rhExpr);
                }
                if (tk == TokenKind.LT) {
                    return new OpLT(t2.startPos, t2.endPos, expr, rhExpr);
                }
                if (tk == TokenKind.LE) {
                    return new OpLE(t2.startPos, t2.endPos, expr, rhExpr);
                }
                if (tk == TokenKind.GE) {
                    return new OpGE(t2.startPos, t2.endPos, expr, rhExpr);
                }
                if (tk == TokenKind.EQ) {
                    return new OpEQ(t2.startPos, t2.endPos, expr, rhExpr);
                }
                Assert.isTrue(tk == TokenKind.NE, "Not-equals token expected");
                return new OpNE(t2.startPos, t2.endPos, expr, rhExpr);
            }
            if (tk == TokenKind.INSTANCEOF) {
                return new OperatorInstanceof(t2.startPos, t2.endPos, expr, rhExpr);
            }
            if (tk == TokenKind.MATCHES) {
                return new OperatorMatches(t2.startPos, t2.endPos, expr, rhExpr);
            }
            Assert.isTrue(tk == TokenKind.BETWEEN, "Between token expected");
            return new OperatorBetween(t2.startPos, t2.endPos, expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatSumExpression() {
        SpelNodeImpl expr = this.eatProductExpression();
        while (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.INC)) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatProductExpression();
            this.checkRightOperand(t2, rhExpr);
            if (t2.kind == TokenKind.PLUS) {
                expr = new OpPlus(t2.startPos, t2.endPos, expr, rhExpr);
                continue;
            }
            if (t2.kind != TokenKind.MINUS) continue;
            expr = new OpMinus(t2.startPos, t2.endPos, expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatProductExpression() {
        SpelNodeImpl expr = this.eatPowerIncDecExpression();
        while (this.peekToken(TokenKind.STAR, TokenKind.DIV, TokenKind.MOD)) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatPowerIncDecExpression();
            this.checkOperands(t2, expr, rhExpr);
            if (t2.kind == TokenKind.STAR) {
                expr = new OpMultiply(t2.startPos, t2.endPos, expr, rhExpr);
                continue;
            }
            if (t2.kind == TokenKind.DIV) {
                expr = new OpDivide(t2.startPos, t2.endPos, expr, rhExpr);
                continue;
            }
            Assert.isTrue(t2.kind == TokenKind.MOD, "Mod token expected");
            expr = new OpModulus(t2.startPos, t2.endPos, expr, rhExpr);
        }
        return expr;
    }

    private SpelNodeImpl eatPowerIncDecExpression() {
        SpelNodeImpl expr = this.eatUnaryExpression();
        if (this.peekToken(TokenKind.POWER)) {
            Token t2 = this.takeToken();
            SpelNodeImpl rhExpr = this.eatUnaryExpression();
            this.checkRightOperand(t2, rhExpr);
            return new OperatorPower(t2.startPos, t2.endPos, expr, rhExpr);
        }
        if (expr != null && this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token t3 = this.takeToken();
            if (t3.getKind() == TokenKind.INC) {
                return new OpInc(t3.startPos, t3.endPos, true, expr);
            }
            return new OpDec(t3.startPos, t3.endPos, true, expr);
        }
        return expr;
    }

    private SpelNodeImpl eatUnaryExpression() {
        if (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.NOT)) {
            Token t2 = this.takeToken();
            SpelNodeImpl expr = this.eatUnaryExpression();
            Assert.state(expr != null, "No node");
            if (t2.kind == TokenKind.NOT) {
                return new OperatorNot(t2.startPos, t2.endPos, expr);
            }
            if (t2.kind == TokenKind.PLUS) {
                return new OpPlus(t2.startPos, t2.endPos, expr);
            }
            Assert.isTrue(t2.kind == TokenKind.MINUS, "Minus token expected");
            return new OpMinus(t2.startPos, t2.endPos, expr);
        }
        if (this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token t3 = this.takeToken();
            SpelNodeImpl expr = this.eatUnaryExpression();
            if (t3.getKind() == TokenKind.INC) {
                return new OpInc(t3.startPos, t3.endPos, false, expr);
            }
            return new OpDec(t3.startPos, t3.endPos, false, expr);
        }
        return this.eatPrimaryExpression();
    }

    private SpelNodeImpl eatPrimaryExpression() {
        SpelNodeImpl start = this.eatStartNode();
        ArrayList<SpelNodeImpl> nodes = null;
        SpelNodeImpl node = this.eatNode();
        while (node != null) {
            if (nodes == null) {
                nodes = new ArrayList<SpelNodeImpl>(4);
                nodes.add(start);
            }
            nodes.add(node);
            node = this.eatNode();
        }
        if (start == null || nodes == null) {
            return start;
        }
        return new CompoundExpression(start.getStartPosition(), ((SpelNodeImpl)nodes.get(nodes.size() - 1)).getEndPosition(), nodes.toArray(new SpelNodeImpl[0]));
    }

    private SpelNodeImpl eatNode() {
        return this.peekToken(TokenKind.DOT, TokenKind.SAFE_NAVI) ? this.eatDottedNode() : this.eatNonDottedNode();
    }

    private SpelNodeImpl eatNonDottedNode() {
        if (this.peekToken(TokenKind.LSQUARE) && this.maybeEatIndexer()) {
            return this.pop();
        }
        return null;
    }

    private SpelNodeImpl eatDottedNode() {
        boolean nullSafeNavigation;
        Token t2 = this.takeToken();
        boolean bl2 = nullSafeNavigation = t2.kind == TokenKind.SAFE_NAVI;
        if (this.maybeEatMethodOrProperty(nullSafeNavigation) || this.maybeEatFunctionOrVar() || this.maybeEatProjection(nullSafeNavigation) || this.maybeEatSelection(nullSafeNavigation)) {
            return this.pop();
        }
        if (this.peekToken() == null) {
            throw this.internalException(t2.startPos, SpelMessage.OOD, new Object[0]);
        }
        throw this.internalException(t2.startPos, SpelMessage.UNEXPECTED_DATA_AFTER_DOT, this.toString(this.peekToken()));
    }

    private boolean maybeEatFunctionOrVar() {
        if (!this.peekToken(TokenKind.HASH)) {
            return false;
        }
        Token t2 = this.takeToken();
        Token functionOrVariableName = this.eatToken(TokenKind.IDENTIFIER);
        SpelNodeImpl[] args = this.maybeEatMethodArgs();
        if (args == null) {
            this.push(new VariableReference(functionOrVariableName.stringValue(), t2.startPos, functionOrVariableName.endPos));
            return true;
        }
        this.push(new FunctionReference(functionOrVariableName.stringValue(), t2.startPos, functionOrVariableName.endPos, args));
        return true;
    }

    private SpelNodeImpl[] maybeEatMethodArgs() {
        if (!this.peekToken(TokenKind.LPAREN)) {
            return null;
        }
        ArrayList<SpelNodeImpl> args = new ArrayList<SpelNodeImpl>();
        this.consumeArguments(args);
        this.eatToken(TokenKind.RPAREN);
        return args.toArray(new SpelNodeImpl[0]);
    }

    private void eatConstructorArgs(List<SpelNodeImpl> accumulatedArguments) {
        if (!this.peekToken(TokenKind.LPAREN)) {
            throw new InternalParseException(new SpelParseException(this.expressionString, this.positionOf(this.peekToken()), SpelMessage.MISSING_CONSTRUCTOR_ARGS, new Object[0]));
        }
        this.consumeArguments(accumulatedArguments);
        this.eatToken(TokenKind.RPAREN);
    }

    private void consumeArguments(List<SpelNodeImpl> accumulatedArguments) {
        Token next;
        Token t2 = this.peekToken();
        Assert.state(t2 != null, "Expected token");
        int pos = t2.startPos;
        do {
            this.nextToken();
            t2 = this.peekToken();
            if (t2 == null) {
                throw this.internalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
            }
            if (t2.kind == TokenKind.RPAREN) continue;
            accumulatedArguments.add(this.eatExpression());
        } while ((next = this.peekToken()) != null && next.kind == TokenKind.COMMA);
        if (next == null) {
            throw this.internalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
        }
    }

    private int positionOf(Token t2) {
        if (t2 == null) {
            return this.expressionString.length();
        }
        return t2.startPos;
    }

    private SpelNodeImpl eatStartNode() {
        if (this.maybeEatLiteral()) {
            return this.pop();
        }
        if (this.maybeEatParenExpression()) {
            return this.pop();
        }
        if (this.maybeEatTypeReference() || this.maybeEatNullReference() || this.maybeEatConstructorReference() || this.maybeEatMethodOrProperty(false) || this.maybeEatFunctionOrVar()) {
            return this.pop();
        }
        if (this.maybeEatBeanReference()) {
            return this.pop();
        }
        if (this.maybeEatProjection(false) || this.maybeEatSelection(false) || this.maybeEatIndexer()) {
            return this.pop();
        }
        if (this.maybeEatInlineListOrMap()) {
            return this.pop();
        }
        return null;
    }

    private boolean maybeEatBeanReference() {
        if (this.peekToken(TokenKind.BEAN_REF) || this.peekToken(TokenKind.FACTORY_BEAN_REF)) {
            BeanReference beanReference;
            Token beanRefToken = this.takeToken();
            Token beanNameToken = null;
            String beanName = null;
            if (this.peekToken(TokenKind.IDENTIFIER)) {
                beanNameToken = this.eatToken(TokenKind.IDENTIFIER);
                beanName = beanNameToken.stringValue();
            } else if (this.peekToken(TokenKind.LITERAL_STRING)) {
                beanNameToken = this.eatToken(TokenKind.LITERAL_STRING);
                beanName = beanNameToken.stringValue();
                beanName = beanName.substring(1, beanName.length() - 1);
            } else {
                throw this.internalException(beanRefToken.startPos, SpelMessage.INVALID_BEAN_REFERENCE, new Object[0]);
            }
            if (beanRefToken.getKind() == TokenKind.FACTORY_BEAN_REF) {
                String beanNameString = String.valueOf(TokenKind.FACTORY_BEAN_REF.tokenChars) + beanName;
                beanReference = new BeanReference(beanRefToken.startPos, beanNameToken.endPos, beanNameString);
            } else {
                beanReference = new BeanReference(beanNameToken.startPos, beanNameToken.endPos, beanName);
            }
            this.constructedNodes.push(beanReference);
            return true;
        }
        return false;
    }

    private boolean maybeEatTypeReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token typeName = this.peekToken();
            Assert.state(typeName != null, "Expected token");
            if (!"T".equals(typeName.stringValue())) {
                return false;
            }
            Token t2 = this.takeToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, t2.stringValue(), t2.startPos, t2.endPos));
                return true;
            }
            this.eatToken(TokenKind.LPAREN);
            SpelNodeImpl node = this.eatPossiblyQualifiedId();
            int dims = 0;
            while (this.peekToken(TokenKind.LSQUARE, true)) {
                this.eatToken(TokenKind.RSQUARE);
                ++dims;
            }
            this.eatToken(TokenKind.RPAREN);
            this.constructedNodes.push(new TypeReference(typeName.startPos, typeName.endPos, node, dims));
            return true;
        }
        return false;
    }

    private boolean maybeEatNullReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token nullToken = this.peekToken();
            Assert.state(nullToken != null, "Expected token");
            if (!"null".equalsIgnoreCase(nullToken.stringValue())) {
                return false;
            }
            this.nextToken();
            this.constructedNodes.push(new NullLiteral(nullToken.startPos, nullToken.endPos));
            return true;
        }
        return false;
    }

    private boolean maybeEatProjection(boolean nullSafeNavigation) {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.PROJECT, true)) {
            return false;
        }
        Assert.state(t2 != null, "No token");
        SpelNodeImpl expr = this.eatExpression();
        Assert.state(expr != null, "No node");
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Projection(nullSafeNavigation, t2.startPos, t2.endPos, expr));
        return true;
    }

    private boolean maybeEatInlineListOrMap() {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.LCURLY, true)) {
            return false;
        }
        Assert.state(t2 != null, "No token");
        SpelNodeImpl expr = null;
        Token closingCurly = this.peekToken();
        if (this.peekToken(TokenKind.RCURLY, true)) {
            Assert.state(closingCurly != null, "No token");
            expr = new InlineList(t2.startPos, closingCurly.endPos, new SpelNodeImpl[0]);
        } else if (this.peekToken(TokenKind.COLON, true)) {
            closingCurly = this.eatToken(TokenKind.RCURLY);
            expr = new InlineMap(t2.startPos, closingCurly.endPos, new SpelNodeImpl[0]);
        } else {
            SpelNodeImpl firstExpression = this.eatExpression();
            if (this.peekToken(TokenKind.RCURLY)) {
                ArrayList<SpelNodeImpl> elements = new ArrayList<SpelNodeImpl>();
                elements.add(firstExpression);
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineList(t2.startPos, closingCurly.endPos, elements.toArray(new SpelNodeImpl[0]));
            } else if (this.peekToken(TokenKind.COMMA, true)) {
                ArrayList<SpelNodeImpl> elements = new ArrayList<SpelNodeImpl>();
                elements.add(firstExpression);
                do {
                    elements.add(this.eatExpression());
                } while (this.peekToken(TokenKind.COMMA, true));
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineList(t2.startPos, closingCurly.endPos, elements.toArray(new SpelNodeImpl[0]));
            } else if (this.peekToken(TokenKind.COLON, true)) {
                ArrayList<SpelNodeImpl> elements = new ArrayList<SpelNodeImpl>();
                elements.add(firstExpression);
                elements.add(this.eatExpression());
                while (this.peekToken(TokenKind.COMMA, true)) {
                    elements.add(this.eatExpression());
                    this.eatToken(TokenKind.COLON);
                    elements.add(this.eatExpression());
                }
                closingCurly = this.eatToken(TokenKind.RCURLY);
                expr = new InlineMap(t2.startPos, closingCurly.endPos, elements.toArray(new SpelNodeImpl[0]));
            } else {
                throw this.internalException(t2.startPos, SpelMessage.OOD, new Object[0]);
            }
        }
        this.constructedNodes.push(expr);
        return true;
    }

    private boolean maybeEatIndexer() {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.LSQUARE, true)) {
            return false;
        }
        Assert.state(t2 != null, "No token");
        SpelNodeImpl expr = this.eatExpression();
        Assert.state(expr != null, "No node");
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Indexer(t2.startPos, t2.endPos, expr));
        return true;
    }

    private boolean maybeEatSelection(boolean nullSafeNavigation) {
        Token t2 = this.peekToken();
        if (!this.peekSelectToken()) {
            return false;
        }
        Assert.state(t2 != null, "No token");
        this.nextToken();
        SpelNodeImpl expr = this.eatExpression();
        if (expr == null) {
            throw this.internalException(t2.startPos, SpelMessage.MISSING_SELECTION_EXPRESSION, new Object[0]);
        }
        this.eatToken(TokenKind.RSQUARE);
        if (t2.kind == TokenKind.SELECT_FIRST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 1, t2.startPos, t2.endPos, expr));
        } else if (t2.kind == TokenKind.SELECT_LAST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 2, t2.startPos, t2.endPos, expr));
        } else {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 0, t2.startPos, t2.endPos, expr));
        }
        return true;
    }

    private SpelNodeImpl eatPossiblyQualifiedId() {
        ArrayDeque<Identifier> qualifiedIdPieces = new ArrayDeque<Identifier>();
        Token node = this.peekToken();
        while (this.isValidQualifiedId(node)) {
            this.nextToken();
            if (node.kind != TokenKind.DOT) {
                qualifiedIdPieces.add(new Identifier(node.stringValue(), node.startPos, node.endPos));
            }
            node = this.peekToken();
        }
        if (qualifiedIdPieces.isEmpty()) {
            if (node == null) {
                throw this.internalException(this.expressionString.length(), SpelMessage.OOD, new Object[0]);
            }
            throw this.internalException(node.startPos, SpelMessage.NOT_EXPECTED_TOKEN, "qualified ID", node.getKind().toString().toLowerCase());
        }
        return new QualifiedIdentifier(((SpelNodeImpl)qualifiedIdPieces.getFirst()).getStartPosition(), ((SpelNodeImpl)qualifiedIdPieces.getLast()).getEndPosition(), qualifiedIdPieces.toArray(new SpelNodeImpl[0]));
    }

    private boolean isValidQualifiedId(Token node) {
        if (node == null || node.kind == TokenKind.LITERAL_STRING) {
            return false;
        }
        if (node.kind == TokenKind.DOT || node.kind == TokenKind.IDENTIFIER) {
            return true;
        }
        String value = node.stringValue();
        return StringUtils.hasLength(value) && VALID_QUALIFIED_ID_PATTERN.matcher(value).matches();
    }

    private boolean maybeEatMethodOrProperty(boolean nullSafeNavigation) {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token methodOrPropertyName = this.takeToken();
            SpelNodeImpl[] args = this.maybeEatMethodArgs();
            if (args == null) {
                this.push(new PropertyOrFieldReference(nullSafeNavigation, methodOrPropertyName.stringValue(), methodOrPropertyName.startPos, methodOrPropertyName.endPos));
                return true;
            }
            this.push(new MethodReference(nullSafeNavigation, methodOrPropertyName.stringValue(), methodOrPropertyName.startPos, methodOrPropertyName.endPos, args));
            return true;
        }
        return false;
    }

    private boolean maybeEatConstructorReference() {
        if (this.peekIdentifierToken("new")) {
            Token newToken = this.takeToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, newToken.stringValue(), newToken.startPos, newToken.endPos));
                return true;
            }
            SpelNodeImpl possiblyQualifiedConstructorName = this.eatPossiblyQualifiedId();
            ArrayList<SpelNodeImpl> nodes = new ArrayList<SpelNodeImpl>();
            nodes.add(possiblyQualifiedConstructorName);
            if (this.peekToken(TokenKind.LSQUARE)) {
                ArrayList<SpelNodeImpl> dimensions = new ArrayList<SpelNodeImpl>();
                while (this.peekToken(TokenKind.LSQUARE, true)) {
                    if (!this.peekToken(TokenKind.RSQUARE)) {
                        dimensions.add(this.eatExpression());
                    } else {
                        dimensions.add(null);
                    }
                    this.eatToken(TokenKind.RSQUARE);
                }
                if (this.maybeEatInlineListOrMap()) {
                    nodes.add(this.pop());
                }
                this.push(new ConstructorReference(newToken.startPos, newToken.endPos, dimensions.toArray(new SpelNodeImpl[0]), nodes.toArray(new SpelNodeImpl[0])));
            } else {
                this.eatConstructorArgs(nodes);
                this.push(new ConstructorReference(newToken.startPos, newToken.endPos, nodes.toArray(new SpelNodeImpl[0])));
            }
            return true;
        }
        return false;
    }

    private void push(SpelNodeImpl newNode) {
        this.constructedNodes.push(newNode);
    }

    private SpelNodeImpl pop() {
        return this.constructedNodes.pop();
    }

    private boolean maybeEatLiteral() {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        if (t2.kind == TokenKind.LITERAL_INT) {
            this.push(Literal.getIntLiteral(t2.stringValue(), t2.startPos, t2.endPos, 10));
        } else if (t2.kind == TokenKind.LITERAL_LONG) {
            this.push(Literal.getLongLiteral(t2.stringValue(), t2.startPos, t2.endPos, 10));
        } else if (t2.kind == TokenKind.LITERAL_HEXINT) {
            this.push(Literal.getIntLiteral(t2.stringValue(), t2.startPos, t2.endPos, 16));
        } else if (t2.kind == TokenKind.LITERAL_HEXLONG) {
            this.push(Literal.getLongLiteral(t2.stringValue(), t2.startPos, t2.endPos, 16));
        } else if (t2.kind == TokenKind.LITERAL_REAL) {
            this.push(Literal.getRealLiteral(t2.stringValue(), t2.startPos, t2.endPos, false));
        } else if (t2.kind == TokenKind.LITERAL_REAL_FLOAT) {
            this.push(Literal.getRealLiteral(t2.stringValue(), t2.startPos, t2.endPos, true));
        } else if (this.peekIdentifierToken("true")) {
            this.push(new BooleanLiteral(t2.stringValue(), t2.startPos, t2.endPos, true));
        } else if (this.peekIdentifierToken("false")) {
            this.push(new BooleanLiteral(t2.stringValue(), t2.startPos, t2.endPos, false));
        } else if (t2.kind == TokenKind.LITERAL_STRING) {
            this.push(new StringLiteral(t2.stringValue(), t2.startPos, t2.endPos, t2.stringValue()));
        } else {
            return false;
        }
        this.nextToken();
        return true;
    }

    private boolean maybeEatParenExpression() {
        if (this.peekToken(TokenKind.LPAREN)) {
            this.nextToken();
            SpelNodeImpl expr = this.eatExpression();
            Assert.state(expr != null, "No node");
            this.eatToken(TokenKind.RPAREN);
            this.push(expr);
            return true;
        }
        return false;
    }

    private Token maybeEatRelationalOperator() {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return null;
        }
        if (t2.isNumericRelationalOperator()) {
            return t2;
        }
        if (t2.isIdentifier()) {
            String idString = t2.stringValue();
            if (idString.equalsIgnoreCase("instanceof")) {
                return t2.asInstanceOfToken();
            }
            if (idString.equalsIgnoreCase("matches")) {
                return t2.asMatchesToken();
            }
            if (idString.equalsIgnoreCase("between")) {
                return t2.asBetweenToken();
            }
        }
        return null;
    }

    private Token eatToken(TokenKind expectedKind) {
        Token t2 = this.nextToken();
        if (t2 == null) {
            int pos = this.expressionString.length();
            throw this.internalException(pos, SpelMessage.OOD, new Object[0]);
        }
        if (t2.kind != expectedKind) {
            throw this.internalException(t2.startPos, SpelMessage.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t2.getKind().toString().toLowerCase());
        }
        return t2;
    }

    private boolean peekToken(TokenKind desiredTokenKind) {
        return this.peekToken(desiredTokenKind, false);
    }

    private boolean peekToken(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        if (t2.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.tokenStreamPointer;
            }
            return true;
        }
        return desiredTokenKind == TokenKind.IDENTIFIER && t2.kind.ordinal() >= TokenKind.DIV.ordinal() && t2.kind.ordinal() <= TokenKind.NOT.ordinal() && t2.data != null;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2) {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        return t2.kind == possible1 || t2.kind == possible2;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2, TokenKind possible3) {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        return t2.kind == possible1 || t2.kind == possible2 || t2.kind == possible3;
    }

    private boolean peekIdentifierToken(String identifierString) {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        return t2.kind == TokenKind.IDENTIFIER && identifierString.equalsIgnoreCase(t2.stringValue());
    }

    private boolean peekSelectToken() {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        return t2.kind == TokenKind.SELECT || t2.kind == TokenKind.SELECT_FIRST || t2.kind == TokenKind.SELECT_LAST;
    }

    private Token takeToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            throw new IllegalStateException("No token");
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token nextToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token peekToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer);
    }

    public String toString(Token t2) {
        if (t2 == null) {
            return "";
        }
        if (t2.getKind().hasPayload()) {
            return t2.stringValue();
        }
        return t2.kind.toString().toLowerCase();
    }

    private void checkOperands(Token token, SpelNodeImpl left, SpelNodeImpl right) {
        this.checkLeftOperand(token, left);
        this.checkRightOperand(token, right);
    }

    private void checkLeftOperand(Token token, SpelNodeImpl operandExpression) {
        if (operandExpression == null) {
            throw this.internalException(token.startPos, SpelMessage.LEFT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private void checkRightOperand(Token token, SpelNodeImpl operandExpression) {
        if (operandExpression == null) {
            throw this.internalException(token.startPos, SpelMessage.RIGHT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private InternalParseException internalException(int startPos, SpelMessage message, Object ... inserts) {
        return new InternalParseException(new SpelParseException(this.expressionString, startPos, message, inserts));
    }
}

