/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Type;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;

public class OperatorInstanceof
extends Operator {
    private Class<?> type;

    public OperatorInstanceof(int startPos, int endPos, SpelNodeImpl ... operands) {
        super("instanceof", startPos, endPos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl rightOperand = this.getRightOperand();
        TypedValue left = this.getLeftOperand().getValueInternal(state);
        TypedValue right = rightOperand.getValueInternal(state);
        Object leftValue = left.getValue();
        Object rightValue = right.getValue();
        if (rightValue == null || !(rightValue instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, rightValue == null ? "null" : rightValue.getClass().getName());
        }
        Class rightClass = (Class)rightValue;
        BooleanTypedValue result = leftValue == null ? BooleanTypedValue.FALSE : BooleanTypedValue.forValue(rightClass.isAssignableFrom(leftValue.getClass()));
        this.type = rightClass;
        if (rightOperand instanceof TypeReference) {
            this.exitTypeDescriptor = "Z";
        }
        return result;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null && this.getLeftOperand().isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf2) {
        this.getLeftOperand().generateCode(mv, cf2);
        CodeFlow.insertBoxIfNecessary(mv, cf2.lastDescriptor());
        Assert.state(this.type != null, "No type available");
        if (this.type.isPrimitive()) {
            mv.visitInsn(87);
            mv.visitInsn(3);
        } else {
            mv.visitTypeInsn(193, Type.getInternalName(this.type));
        }
        cf2.pushDescriptor(this.exitTypeDescriptor);
    }
}

