/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IteratingCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.Generator;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.Parser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;

public class ExtensionStack
extends ContainerLifeCycle
implements IncomingFrames,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(ExtensionStack.class);
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private final ExtensionFactory factory;
    private List<Extension> extensions;
    private IncomingFrames nextIncoming;
    private OutgoingFrames nextOutgoing;

    public ExtensionStack(ExtensionFactory factory) {
        this.factory = factory;
    }

    public void configure(Generator generator) {
        generator.configureFromExtensions(this.extensions);
    }

    public void configure(Parser parser) {
        parser.configureFromExtensions(this.extensions);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.extensions != null && this.extensions.size() > 0) {
            Extension ext;
            ListIterator<Extension> exts = this.extensions.listIterator();
            while (exts.hasNext()) {
                ext = exts.next();
                ext.setNextOutgoingFrames(this.nextOutgoing);
                this.nextOutgoing = ext;
                if (!(ext instanceof LifeCycle)) continue;
                this.addBean(ext, true);
            }
            while (exts.hasPrevious()) {
                ext = exts.previous();
                ext.setNextIncomingFrames(this.nextIncoming);
                this.nextIncoming = ext;
            }
        }
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[size=%d,queueSize=%d]", this.getClass().getSimpleName(), this.hashCode(), this.extensions.size(), this.getQueueSize());
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncoming.incomingFrame(frame);
    }

    public void negotiate(List<ExtensionConfig> configs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extension Configs={}", configs);
        }
        this.extensions = new ArrayList<Extension>();
        String[] rsvClaims = new String[3];
        for (ExtensionConfig config : configs) {
            Extension ext = this.factory.newInstance(config);
            if (ext == null) continue;
            if (ext.isRsv1User() && rsvClaims[0] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV1", config, rsvClaims[0]);
                continue;
            }
            if (ext.isRsv2User() && rsvClaims[1] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV2", config, rsvClaims[1]);
                continue;
            }
            if (ext.isRsv3User() && rsvClaims[2] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV3", config, rsvClaims[2]);
                continue;
            }
            this.extensions.add(ext);
            this.addBean(ext);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Extension: {}", config);
            }
            if (ext.isRsv1User()) {
                rsvClaims[0] = ext.getName();
            }
            if (ext.isRsv2User()) {
                rsvClaims[1] = ext.getName();
            }
            if (!ext.isRsv3User()) continue;
            rsvClaims[2] = ext.getName();
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", entry);
        }
        this.offerEntry(entry);
        this.flusher.iterate();
    }

    public void setNextIncoming(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    public void setNextOutgoing(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry entry) {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            this.entries.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            return this.entries.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getQueueSize() {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            return this.entries.size();
        }
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("ExtensionStack[");
        s2.append("queueSize=").append(this.getQueueSize());
        s2.append(",extensions=");
        if (this.extensions == null) {
            s2.append("<null>");
        } else {
            s2.append('[');
            boolean delim = false;
            for (Extension ext : this.extensions) {
                if (delim) {
                    s2.append(',');
                }
                if (ext == null) {
                    s2.append("<null>");
                } else {
                    s2.append(ext.getName());
                }
                delim = true;
            }
            s2.append(']');
        }
        s2.append(",incoming=").append(this.nextIncoming == null ? "<null>" : this.nextIncoming.getClass().getName());
        s2.append(",outgoing=").append(this.nextOutgoing == null ? "<null>" : this.nextOutgoing.getClass().getName());
        s2.append("]");
        return s2.toString();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            this.current = ExtensionStack.this.pollEntry();
            if (this.current == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entering IDLE", new Object[0]);
                }
                return IteratingCallback.Action.IDLE;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {}", this.current);
            }
            ExtensionStack.this.nextOutgoing.outgoingFrame(this.current.frame, this, this.current.batchMode);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x2) {
        }

        @Override
        public void writeSuccess() {
            this.notifyCallbackSuccess(this.current.callback);
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable x2) {
            this.notifyCallbackFailure(this.current.callback, x2);
            this.succeeded();
        }

        private void notifyCallbackSuccess(WriteCallback callback) {
            block3: {
                try {
                    if (callback != null) {
                        callback.writeSuccess();
                    }
                }
                catch (Throwable x2) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + callback, x2);
                }
            }
        }

        private void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
            block3: {
                try {
                    if (callback != null) {
                        callback.writeFailed(failure);
                    }
                }
                catch (Throwable x2) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + callback, x2);
                }
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

