/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public abstract class AbstractExtension
extends AbstractLifeCycle
implements Extension {
    private final Logger log = Log.getLogger(this.getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;

    @Deprecated
    public void init(WebSocketContainerScope container) {
        this.init(container.getPolicy(), container.getBufferPool());
    }

    public void init(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public boolean isRsv1User() {
        return false;
    }

    @Override
    public boolean isRsv2User() {
        return false;
    }

    @Override
    public boolean isRsv3User() {
        return false;
    }

    protected void nextOutgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("nextOutgoingFrame({})", frame);
            }
            this.nextOutgoing.outgoingFrame(frame, callback, batchMode);
        }
        catch (Throwable t2) {
            if (callback != null) {
                callback.writeFailed(t2);
            }
            this.log.warn(t2);
        }
    }

    public void setConfig(ExtensionConfig config) {
        this.config = config;
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    @Override
    public void setNextOutgoingFrames(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

