/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.CloseStatus;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.RemoteEndpoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.SuspendToken;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.LogicalConnection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.RemoteEndpointFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.io.DisconnectCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class WebSocketSession
extends ContainerLifeCycle
implements Connection.Listener,
Session,
IncomingFrames,
OutgoingFrames,
RemoteEndpointFactory {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private static final RemoteEndpointFactory defaultRemoteEndpointFactory;
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final Executor executor;
    private final WebSocketPolicy policy;
    private final AtomicBoolean onCloseCalled = new AtomicBoolean(false);
    private final RemoteEndpointFactory remoteEndpointFactory;
    private ClassLoader classLoader;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private RemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private CompletableFuture<Session> openFuture;

    public WebSocketSession(WebSocketContainerScope containerScope, URI requestURI, EventDriver websocket, LogicalConnection connection) {
        Objects.requireNonNull(containerScope, "Container Scope cannot be null");
        Objects.requireNonNull(requestURI, "Request URI cannot be null");
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.containerScope = containerScope;
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.executor = connection.getExecutor();
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.policy = websocket.getPolicy();
        RemoteEndpointFactory remoteEndpointFactory = this.remoteEndpointFactory = defaultRemoteEndpointFactory == null ? this : defaultRemoteEndpointFactory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using RemoteEndpointFactory: {}", this.remoteEndpointFactory);
        }
        this.connection.setSession(this);
        this.addBean(this.connection);
        this.addBean(this.websocket);
        this.notifySessionListeners(containerScope, listener -> listener.onSessionCreated(this));
    }

    public void close(Throwable cause) {
        this.connection.close(cause);
    }

    @Override
    public void close() {
        this.close(new CloseInfo(1000), null);
    }

    @Override
    public void close(CloseStatus closeStatus) {
        this.close(new CloseInfo(closeStatus.getCode(), closeStatus.getPhrase()), null);
    }

    private void close(CloseInfo closeInfo, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({})", closeInfo);
        }
        this.connection.close(closeInfo, callback);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", this);
        }
        this.connection.close(new CloseInfo(1001, "Shutdown"), new DisconnectCallback(this.connection));
        super.doStop();
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,batchMode=%s,idleTimeout=%d,requestURI=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getPolicy().getBehavior(), this.getBatchMode(), this.getIdleTimeout(), this.getRequestURI()});
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public WebSocketContainerScope getContainerScope() {
        return this.containerScope;
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public RemoteEndpoint getRemote() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.getRemote()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        return this.remote;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public void incomingFrame(Frame frame) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.connection.canReadWebSocketFrames()) {
                this.incomingHandler.incomingFrame(frame);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt to process frame when in wrong connection state: " + this.connection.toStateString(), new RuntimeException("TRACE"));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.onCloseCalled.get()) {
            block4: {
                try {
                    if (callback != null) {
                        callback.writeFailed(new WebSocketException("Session closed"));
                    }
                }
                catch (Throwable x2) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Exception while notifying failure of callback " + callback, x2);
                }
            }
            return;
        }
        this.outgoingHandler.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return !this.onCloseCalled.get() && this.connection.isOpen();
    }

    public void callApplicationOnClose(CloseInfo closeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("callApplicationOnClose({})", closeInfo);
        }
        if (this.onCloseCalled.compareAndSet(false, true)) {
            try {
                this.websocket.onClose(closeInfo);
            }
            catch (Throwable t2) {
                LOG.warn("Exception while notifying onClose", t2);
            }
        }
    }

    public void callApplicationOnError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("callApplicationOnError()", cause);
        }
        if (this.openFuture != null) {
            this.openFuture.completeExceptionally(cause);
        }
        if (!this.onCloseCalled.get()) {
            try {
                this.websocket.onError(cause);
            }
            catch (Throwable t2) {
                LOG.warn("Exception while notifying onError", t2);
            }
        }
    }

    @Override
    public void onClosed(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionClosed()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (connection == this.connection) {
            this.connection.disconnect();
            try {
                this.notifySessionListeners(this.containerScope, listener -> listener.onSessionClosed(this));
            }
            catch (Throwable cause) {
                LOG.ignore(cause);
            }
        }
    }

    @Override
    public void onOpened(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public WebSocketRemoteEndpoint newRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoingFrames, BatchMode batchMode) {
        return new WebSocketRemoteEndpoint(connection, outgoingFrames, this.getBatchMode());
    }

    public void open() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope ignored = new ThreadClassLoaderScope(this.classLoader);){
            if (this.connection.opening()) {
                this.remote = this.remoteEndpointFactory.newRemoteEndpoint(this.connection, this, this.getBatchMode());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
                }
                this.websocket.openSession(this);
                if (this.connection.opened()) {
                    try {
                        this.notifySessionListeners(this.containerScope, listener -> listener.onSessionOpened(this));
                    }
                    catch (Throwable t2) {
                        LOG.ignore(t2);
                    }
                } else {
                    this.callApplicationOnClose(new CloseInfo(1006, "Failed to open local endpoint"));
                    this.disconnect();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] open -> {}", new Object[]{this.getPolicy().getBehavior(), this.dump()});
                }
                if (this.openFuture != null) {
                    this.openFuture.complete(this);
                }
            }
        }
        catch (Throwable t3) {
            this.close(t3);
        }
    }

    public void setFuture(CompletableFuture<Session> fut) {
        this.openFuture = fut;
        fut.whenComplete((s2, t2) -> {
            if (t2 != null) {
                this.close((Throwable)t2);
            }
        });
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
        this.protocolVersion = request.getProtocolVersion();
        this.parameterMap.clear();
        if (request.getParameterMap() != null) {
            for (Map.Entry<String, List<String>> entry : request.getParameterMap().entrySet()) {
                List<String> values = entry.getValue();
                if (values != null) {
                    this.parameterMap.put(entry.getKey(), values.toArray(new String[values.size()]));
                    continue;
                }
                this.parameterMap.put(entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    @Override
    public SuspendToken suspend() {
        if (this.onCloseCalled.get()) {
            throw new IllegalStateException("Not open");
        }
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    private void notifySessionListeners(WebSocketContainerScope scope, Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : scope.getSessionListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x2) {
                LOG.info("Exception while invoking listener " + listener, x2);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append((Object)this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    static {
        Iterator<RemoteEndpointFactory> iter = ServiceLoader.load(RemoteEndpointFactory.class).iterator();
        RemoteEndpointFactory remoteEndpointFactory = defaultRemoteEndpointFactory = iter.hasNext() ? iter.next() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discovered default RemoteEndpointFactory: {}", defaultRemoteEndpointFactory);
        }
    }
}

