/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<List<InetSocketAddress>> var3);

    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        public Async(Executor executor, Scheduler scheduler, long timeout) {
            this.executor = executor;
            this.scheduler = scheduler;
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void resolve(String host, int port, Promise<List<InetSocketAddress>> promise) {
            this.executor.execute(() -> {
                Scheduler.Task task = null;
                AtomicBoolean complete = new AtomicBoolean();
                if (this.timeout > 0L) {
                    Thread thread = Thread.currentThread();
                    task = this.scheduler.schedule(() -> {
                        if (complete.compareAndSet(false, true)) {
                            promise.failed(new TimeoutException("DNS timeout " + this.getTimeout() + " ms"));
                            thread.interrupt();
                        }
                    }, this.timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long start = System.nanoTime();
                    InetAddress[] addresses = InetAddress.getAllByName(host);
                    long elapsed = System.nanoTime() - start;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved {} in {} ms", host, TimeUnit.NANOSECONDS.toMillis(elapsed));
                    }
                    ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(addresses.length);
                    for (InetAddress address : addresses) {
                        result.add(new InetSocketAddress(address, port));
                    }
                    if (complete.compareAndSet(false, true)) {
                        if (result.isEmpty()) {
                            promise.failed(new UnknownHostException());
                        } else {
                            promise.succeeded(result);
                        }
                    }
                }
                catch (Throwable x2) {
                    if (complete.compareAndSet(false, true)) {
                        promise.failed(x2);
                    }
                }
                finally {
                    if (task != null) {
                        task.cancel();
                    }
                }
            });
        }
    }
}

