/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.List;

public class MultiException
extends Exception {
    private List<Throwable> nested;

    public MultiException() {
        super("Multiple exceptions", null, false, false);
        this.nested = new ArrayList<Throwable>();
    }

    private MultiException(List<Throwable> nested) {
        super("Multiple exceptions");
        this.nested = new ArrayList<Throwable>(nested);
        if (nested.size() > 0) {
            this.initCause(nested.get(0));
        }
        for (Throwable t2 : nested) {
            if (t2 == this) continue;
            this.addSuppressed(t2);
        }
    }

    public void add(Throwable e2) {
        if (e2 instanceof MultiException) {
            MultiException me = (MultiException)e2;
            this.nested.addAll(me.nested);
        } else {
            this.nested.add(e2);
        }
    }

    public void ifExceptionThrow() throws Exception {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable th = this.nested.get(0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw new MultiException(this.nested);
            }
            default: {
                throw new MultiException(this.nested);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(MultiException.class.getSimpleName());
        if (this.nested == null || this.nested.size() <= 0) {
            str.append("[]");
        } else {
            str.append(this.nested);
        }
        return str.toString();
    }
}

