/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.AbstractByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class MappedByteBufferPool
extends AbstractByteBufferPool {
    private static final Logger LOG = Log.getLogger(MappedByteBufferPool.class);
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final Function<Integer, ByteBufferPool.Bucket> _newBucket;

    public MappedByteBufferPool() {
        this(-1);
    }

    public MappedByteBufferPool(int factor) {
        this(factor, -1);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength) {
        this(factor, maxQueueLength, null);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket) {
        this(factor, maxQueueLength, newBucket, -1L, -1L);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket, long maxHeapMemory, long maxDirectMemory) {
        super(factor, maxQueueLength, maxHeapMemory, maxDirectMemory);
        this._newBucket = newBucket != null ? newBucket : this::newBucket;
    }

    private ByteBufferPool.Bucket newBucket(int key) {
        return new ByteBufferPool.Bucket(this, key * this.getCapacityFactor(), this.getMaxQueueLength());
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        int b2 = this.bucketFor(size);
        int capacity = b2 * this.getCapacityFactor();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buffers = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)buffers.get(b2);
        if (bucket == null) {
            return this.newByteBuffer(capacity, direct);
        }
        ByteBuffer buffer = bucket.acquire();
        if (buffer == null) {
            return this.newByteBuffer(capacity, direct);
        }
        this.decrementMemory(buffer);
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int capacity = buffer.capacity();
        if (capacity % this.getCapacityFactor() != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(buffer));
            }
            return;
        }
        int b2 = this.bucketFor(capacity);
        boolean direct = buffer.isDirect();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = buckets.computeIfAbsent(b2, this._newBucket);
        bucket.release(buffer);
        this.incrementMemory(buffer);
        this.releaseExcessMemory(direct, this::clearOldestBucket);
    }

    private void clearOldestBucket(boolean direct) {
        ByteBufferPool.Bucket bucket;
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(direct);
        for (Map.Entry entry : buckets.entrySet()) {
            ByteBufferPool.Bucket bucket2 = (ByteBufferPool.Bucket)entry.getValue();
            long lastUpdate = bucket2.getLastUpdate();
            if (lastUpdate >= oldest) continue;
            oldest = lastUpdate;
            index = (Integer)entry.getKey();
        }
        if (index >= 0 && (bucket = (ByteBufferPool.Bucket)buckets.remove(index)) != null) {
            bucket.clear(this::decrementMemory);
        }
    }

    private int bucketFor(int size) {
        int factor = this.getCapacityFactor();
        int bucket = size / factor;
        if (bucket * factor != size) {
            ++bucket;
        }
        return bucket;
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean direct) {
        return direct ? this._directBuffers : this._heapBuffers;
    }
}

