/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;
import java.util.EnumSet;

public enum HttpHeaderValue {
    CLOSE("close"),
    CHUNKED("chunked"),
    GZIP("gzip"),
    IDENTITY("identity"),
    KEEP_ALIVE("keep-alive"),
    CONTINUE("100-continue"),
    PROCESSING("102-processing"),
    TE("TE"),
    BYTES("bytes"),
    NO_CACHE("no-cache"),
    UPGRADE("Upgrade"),
    UNKNOWN("::UNKNOWN::");

    public static final Trie<HttpHeaderValue> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private static EnumSet<HttpHeader> __known;

    private HttpHeaderValue(String s2) {
        this._string = s2;
        this._buffer = BufferUtil.toBuffer(s2);
    }

    public boolean is(String s2) {
        return this._string.equalsIgnoreCase(s2);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    static {
        CACHE = new ArrayTrie<HttpHeaderValue>();
        for (HttpHeaderValue value : HttpHeaderValue.values()) {
            if (value == UNKNOWN) continue;
            CACHE.put(value.toString(), value);
        }
        __known = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.CONTENT_ENCODING);
    }
}

