/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.NoHttpResponseException;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolException;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.MessageConstraints;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.DefaultHttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.io.AbstractMessageParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.io.SessionInputBuffer;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.LineParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i2 = sessionBuffer.readLine(this.lineBuf);
            if (i2 == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i2 == -1 || this.reject(this.lineBuf, count)) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }

    protected boolean reject(CharArrayBuffer line, int count) {
        return false;
    }
}

