/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.DeletingPathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.StandardDeleteOption;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public final class PathUtils {
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];

    public static Counters.PathCounters delete(Path path) throws IOException {
        return PathUtils.delete(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters delete(Path path, DeleteOption ... options) throws IOException {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path, options) : PathUtils.deleteFile(path, options);
    }

    public static Counters.PathCounters deleteDirectory(Path directory, DeleteOption ... options) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), options, new String[0]), directory).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path file, DeleteOption ... options) throws IOException {
        long size;
        if (Files.isDirectory(file, LinkOption.NOFOLLOW_LINKS)) {
            throw new NoSuchFileException(file.toString());
        }
        Counters.PathCounters pathCounts = Counters.longPathCounters();
        boolean exists = Files.exists(file, LinkOption.NOFOLLOW_LINKS);
        long l2 = size = exists ? Files.size(file) : 0L;
        if (PathUtils.overrideReadOnly(options) && exists) {
            PathUtils.setReadOnly(file, false, LinkOption.NOFOLLOW_LINKS);
        }
        if (Files.deleteIfExists(file)) {
            pathCounts.getFileCounter().increment();
            pathCounts.getByteCounter().add(size);
        }
        return pathCounts;
    }

    private static boolean overrideReadOnly(DeleteOption[] options) {
        if (options == null) {
            return false;
        }
        for (DeleteOption deleteOption : options) {
            if (deleteOption != StandardDeleteOption.OVERRIDE_READ_ONLY) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyDirectory(Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            if (directoryStream.iterator().hasNext()) {
                boolean bl2 = false;
                return bl2;
            }
        }
        return true;
    }

    public static Path setReadOnly(Path path, boolean readOnly, LinkOption ... options) throws IOException {
        DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, options);
        if (fileAttributeView != null) {
            fileAttributeView.setReadOnly(readOnly);
            return path;
        }
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, options);
        if (posixFileAttributeView != null) {
            PosixFileAttributes readAttributes = posixFileAttributeView.readAttributes();
            Set<PosixFilePermission> permissions = readAttributes.permissions();
            permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
            return Files.setPosixFilePermissions(path, permissions);
        }
        throw new IOException("No DosFileAttributeView or PosixFileAttributeView for " + path);
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, Path directory) throws IOException {
        Files.walkFileTree(directory, visitor);
        return visitor;
    }
}

