/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char DIR_SEPARATOR = File.separatorChar;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    private static final byte[] SKIP_BYTE_BUFFER = new byte[8192];

    public static void close(Closeable closeable, IOConsumer<IOException> consumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e2) {
                    if (consumer == null) break block3;
                    consumer.accept(e2);
                }
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOUtils.copyLarge(input, output, new byte[bufferSize]);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 8192);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        if (input != null) {
            int n2;
            while (-1 != (n2 = input.read(buffer))) {
                output.write(buffer, 0, n2);
                count += (long)n2;
            }
        }
        return count;
    }

    public static int length(byte[] array) {
        return array == null ? 0 : array.length;
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static byte[] readFully(InputStream input, int length) throws IOException {
        byte[] buffer = new byte[length];
        IOUtils.readFully(input, buffer, 0, buffer.length);
        return buffer;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }
}

