/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ByteSink {
    protected ByteSink() {
    }

    public abstract OutputStream openStream() throws IOException;

    public void write(byte[] bytes) throws IOException {
        Preconditions.checkNotNull(bytes);
        try (Closer closer = Closer.create();){
            OutputStream out = closer.register(this.openStream());
            out.write(bytes);
            out.flush();
        }
    }

    public long writeFrom(InputStream input) throws IOException {
        Preconditions.checkNotNull(input);
        try (Closer closer = Closer.create();){
            OutputStream out = closer.register(this.openStream());
            long written = ByteStreams.copy(input, out);
            out.flush();
            long l2 = written;
            return l2;
        }
    }
}

