/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import java.io.Serializable;
import java.util.function.BiPredicate;

public abstract class Equivalence<T>
implements BiPredicate<T, T> {
    protected Equivalence() {
    }

    public final boolean equivalent(T a2, T b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return this.doEquivalent(a2, b2);
    }

    @Override
    @Deprecated
    public final boolean test(T t2, T u2) {
        return this.equivalent(t2, u2);
    }

    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    protected abstract int doHash(T var1);

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return false;
        }

        @Override
        protected int doHash(Object o2) {
            return System.identityHashCode(o2);
        }
    }

    static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return a2.equals(b2);
        }

        @Override
        protected int doHash(Object o2) {
            return o2.hashCode();
        }
    }
}

