/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.NotNull;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.AsmCachedFieldFactory;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerAnnotationsUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerConfig;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerGenericsUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.FieldSerializerUnsafeUtil;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.Generics;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.ObjectCachedFieldFactory;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.ObjectField;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.IntArray;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.Util;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    final TypeVariable[] typeParameters;
    final Class componentType;
    protected final FieldSerializerConfig config;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    protected HashSet<CachedField> removedFields = new HashSet();
    Object access;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private FieldSerializerAnnotationsUtil annotationsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private boolean hasObjectFields = false;
    static CachedFieldFactory asmFieldFactory;
    static CachedFieldFactory objectFieldFactory;
    static CachedFieldFactory unsafeFieldFactory;
    static boolean unsafeAvailable;
    static Class<?> unsafeUtilClass;
    static Method sortFieldsByOffsetMethod;

    public FieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, null);
    }

    public FieldSerializer(Kryo kryo, Class type, Class[] generics) {
        this(kryo, type, generics, kryo.getFieldSerializerConfig().clone());
    }

    protected FieldSerializer(Kryo kryo, Class type, Class[] generics, FieldSerializerConfig config) {
        if (Log.TRACE) {
            Log.trace("kryo", "Optimize ints: " + this.varIntsEnabled);
        }
        this.config = config;
        this.kryo = kryo;
        this.type = type;
        this.generics = generics;
        this.typeParameters = type.getTypeParameters();
        this.componentType = this.typeParameters == null || this.typeParameters.length == 0 ? type.getComponentType() : null;
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = FieldSerializerUnsafeUtil.Factory.getInstance(this);
        this.annotationsUtil = new FieldSerializerAnnotationsUtil(this);
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        this.rebuildCachedFields(false);
    }

    protected void rebuildCachedFields(boolean minorRebuild) {
        List<Field> validTransientFields;
        List<Field> validFields;
        if (Log.TRACE && this.generics != null) {
            Log.trace("kryo", "Generic type parameters: " + Arrays.toString(this.generics));
        }
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        if (this.config.isOptimizedGenerics()) {
            Generics genScope;
            this.genericsScope = genScope = this.genericsUtil.buildGenericsScope(this.type, this.generics);
            if (this.genericsScope != null) {
                this.kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        IntArray useAsm = new IntArray();
        if (!minorRebuild) {
            List<Field> allFields = new ArrayList<Field>();
            for (Class nextClass = this.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                Field[] declaredFields = nextClass.getDeclaredFields();
                if (declaredFields == null) continue;
                for (Field f2 : declaredFields) {
                    if (Modifier.isStatic(f2.getModifiers())) continue;
                    allFields.add(f2);
                }
            }
            ObjectMap context = this.kryo.getContext();
            if (this.useMemRegions && !this.config.isUseAsm() && unsafeAvailable) {
                try {
                    Field[] allFieldsArray = (Field[])sortFieldsByOffsetMethod.invoke(null, allFields);
                    allFields = Arrays.asList(allFieldsArray);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Cannot invoke UnsafeUtil.sortFieldsByOffset()", e2);
                }
            }
            validFields = this.buildValidFields(false, allFields, context, useAsm);
            validTransientFields = this.buildValidFields(true, allFields, context, useAsm);
            if (this.config.isUseAsm() && !Util.IS_ANDROID && Modifier.isPublic(this.type.getModifiers()) && useAsm.indexOf(1) != -1) {
                try {
                    this.access = FieldAccess.get(this.type);
                }
                catch (RuntimeException e2) {}
            }
        } else {
            validFields = this.buildValidFieldsFromCachedFields(this.fields, useAsm);
            validTransientFields = this.buildValidFieldsFromCachedFields(this.transientFields, useAsm);
        }
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(validFields.size());
        ArrayList<CachedField> cachedTransientFields = new ArrayList<CachedField>(validTransientFields.size());
        this.createCachedFields(useAsm, validFields, cachedFields, 0);
        this.createCachedFields(useAsm, validTransientFields, cachedTransientFields, validFields.size());
        Collections.sort(cachedFields, this);
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        Collections.sort(cachedTransientFields, this);
        this.transientFields = cachedTransientFields.toArray(new CachedField[cachedTransientFields.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.getGenericsResolver().popScope();
        }
        if (!minorRebuild) {
            for (CachedField field : this.removedFields) {
                this.removeField(field);
            }
        }
        this.annotationsUtil.processAnnotatedFields(this);
    }

    private List<Field> buildValidFieldsFromCachedFields(CachedField[] cachedFields, IntArray useAsm) {
        ArrayList<Field> fields = new ArrayList<Field>(cachedFields.length);
        for (CachedField f2 : cachedFields) {
            fields.add(f2.field);
            useAsm.add(f2.accessIndex > -1 ? 1 : 0);
        }
        return fields;
    }

    private List<Field> buildValidFields(boolean transientFields, List<Field> allFields, ObjectMap context, IntArray useAsm) {
        ArrayList<Field> result = new ArrayList<Field>(allFields.size());
        int n2 = allFields.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Optional optional;
            Field field = allFields.get(i2);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) != transientFields || Modifier.isStatic(modifiers) || field.isSynthetic() && this.config.isIgnoreSyntheticFields()) continue;
            if (!field.isAccessible()) {
                if (!this.config.isSetFieldsAsAccessible()) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !context.containsKey(optional.value())) continue;
            result.add(field);
            useAsm.add(!Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        return result;
    }

    private void createCachedFields(IntArray useAsm, List<Field> validFields, List<CachedField> cachedFields, int baseIndex) {
        if (this.config.isUseAsm() || !this.useMemRegions) {
            int n2 = validFields.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = validFields.get(i2);
                int accessIndex = -1;
                if (this.access != null && useAsm.get(baseIndex + i2) == 1) {
                    accessIndex = ((FieldAccess)this.access).getIndex(field.getName());
                }
                cachedFields.add(this.newCachedField(field, cachedFields.size(), accessIndex));
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(validFields, cachedFields, baseIndex, useAsm);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        if (!this.config.isOptimizedGenerics()) {
            return;
        }
        this.generics = generics;
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields(true);
        }
    }

    public Class[] getGenerics() {
        return this.generics;
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field, int fieldIndex, int accessIndex) {
        CachedField cachedField;
        Type fieldGenericType;
        Class[] fieldClass = new Class[]{field.getType()};
        Type type = fieldGenericType = this.config.isOptimizedGenerics() ? field.getGenericType() : null;
        if (!this.config.isOptimizedGenerics() || fieldGenericType == fieldClass[0]) {
            if (Log.TRACE) {
                Log.trace("kryo", "Field " + field.getName() + ": " + fieldClass[0]);
            }
            cachedField = this.newMatchingCachedField(field, accessIndex, fieldClass[0], fieldGenericType, null);
        } else {
            cachedField = this.genericsUtil.newCachedFieldOfGenericType(field, accessIndex, fieldClass, fieldGenericType);
        }
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.config.isUseAsm()) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = accessIndex;
        boolean bl2 = cachedField.canBeNull = this.config.isFieldsCanBeNull() && !fieldClass[0].isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(fieldClass[0]) || this.config.isFixedFieldTypes()) {
            cachedField.valueClass = fieldClass[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field, int accessIndex, Class fieldClass, Type fieldGenericType, Class[] fieldGenerics) {
        CachedField cachedField;
        if (accessIndex != -1) {
            cachedField = this.getAsmFieldFactory().createCachedField(fieldClass, field, this);
        } else if (!this.config.isUseAsm()) {
            cachedField = this.getUnsafeFieldFactory().createCachedField(fieldClass, field, this);
        } else {
            cachedField = this.getObjectFieldFactory().createCachedField(fieldClass, field, this);
            if (this.config.isOptimizedGenerics()) {
                if (fieldGenerics != null) {
                    ((ObjectField)cachedField).generics = fieldGenerics;
                } else if (fieldGenericType != null) {
                    Object[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
                    ((ObjectField)cachedField).generics = cachedFieldGenerics;
                    if (Log.TRACE) {
                        Log.trace("kryo", "Field generics: " + Arrays.toString(cachedFieldGenerics));
                    }
                }
            }
        }
        return cachedField;
    }

    private CachedFieldFactory getAsmFieldFactory() {
        if (asmFieldFactory == null) {
            asmFieldFactory = new AsmCachedFieldFactory();
        }
        return asmFieldFactory;
    }

    private CachedFieldFactory getObjectFieldFactory() {
        if (objectFieldFactory == null) {
            objectFieldFactory = new ObjectCachedFieldFactory();
        }
        return objectFieldFactory;
    }

    private CachedFieldFactory getUnsafeFieldFactory() {
        if (unsafeFieldFactory == null) {
            try {
                unsafeFieldFactory = (CachedFieldFactory)this.getClass().getClassLoader().loadClass("com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers.UnsafeCachedFieldFactory").newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException("Cannot create UnsafeFieldFactory", e2);
            }
        }
        return unsafeFieldFactory;
    }

    @Override
    public int compare(CachedField o1, CachedField o2) {
        return this.getCachedFieldName(o1).compareTo(this.getCachedFieldName(o2));
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.config.setFieldsCanBeNull(fieldsCanBeNull);
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.config.setFieldsAsAccessible(setFieldsAsAccessible);
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.config.setIgnoreSyntheticFields(ignoreSyntheticFields);
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.config.setFixedFieldTypes(fixedFieldTypes);
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean setUseAsm) {
        this.config.setUseAsm(setUseAsm);
        this.rebuildCachedFields();
    }

    public void setCopyTransient(boolean setCopyTransient) {
        this.config.setCopyTransient(setCopyTransient);
    }

    public void setSerializeTransient(boolean setSerializeTransient) {
        this.config.setSerializeTransient(setSerializeTransient);
    }

    public void setOptimizedGenerics(boolean setOptimizedGenerics) {
        this.config.setOptimizedGenerics(setOptimizedGenerics);
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        int i2;
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer.write fields of class: " + object.getClass().getName());
        }
        if (this.config.isOptimizedGenerics()) {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        CachedField[] fields = this.fields;
        int n2 = fields.length;
        for (i2 = 0; i2 < n2; ++i2) {
            fields[i2].write(output, object);
        }
        if (this.config.isSerializeTransient()) {
            n2 = this.transientFields.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.transientFields[i2].write(output, object);
            }
        }
        if (this.config.isOptimizedGenerics() && this.genericsScope != null) {
            kryo.getGenericsResolver().popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        try {
            int i2;
            if (this.config.isOptimizedGenerics()) {
                if (this.typeParameters != null && this.generics != null) {
                    this.rebuildCachedFields();
                }
                if (this.genericsScope != null) {
                    kryo.getGenericsResolver().pushScope(type, this.genericsScope);
                }
            }
            T object = this.create(kryo, input, type);
            kryo.reference(object);
            CachedField[] fields = this.fields;
            int n2 = fields.length;
            for (i2 = 0; i2 < n2; ++i2) {
                fields[i2].read(input, object);
            }
            if (this.config.isSerializeTransient()) {
                n2 = this.transientFields.length;
                for (i2 = 0; i2 < n2; ++i2) {
                    this.transientFields[i2].read(input, object);
                }
            }
            T t2 = object;
            return t2;
        }
        finally {
            if (this.config.isOptimizedGenerics() && this.genericsScope != null && kryo.getGenericsResolver() != null) {
                kryo.getGenericsResolver().popScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> type) {
        return kryo.newInstance(type);
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.fields) {
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    protected String getCachedFieldName(CachedField cachedField) {
        return this.config.getCachedFieldNameStrategy().getName(cachedField);
    }

    public void removeField(String fieldName) {
        CachedField cachedField;
        int i2;
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            cachedField = this.fields[i2];
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i2);
            System.arraycopy(this.fields, i2 + 1, newFields, i2, newFields.length - i2);
            this.fields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        for (i2 = 0; i2 < this.transientFields.length; ++i2) {
            cachedField = this.transientFields[i2];
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, newFields, 0, i2);
            System.arraycopy(this.transientFields, i2 + 1, newFields, i2, newFields.length - i2);
            this.transientFields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(CachedField removeField) {
        CachedField cachedField;
        int i2;
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            cachedField = this.fields[i2];
            if (cachedField != removeField) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i2);
            System.arraycopy(this.fields, i2 + 1, newFields, i2, newFields.length - i2);
            this.fields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        for (i2 = 0; i2 < this.transientFields.length; ++i2) {
            cachedField = this.transientFields[i2];
            if (cachedField != removeField) continue;
            CachedField[] newFields = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, newFields, 0, i2);
            System.arraycopy(this.transientFields, i2 + 1, newFields, i2, newFields.length - i2);
            this.transientFields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        throw new IllegalArgumentException("Field \"" + removeField + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public CachedField[] getTransientFields() {
        return this.transientFields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.config.isUseAsm();
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    public boolean getCopyTransient() {
        return this.config.isCopyTransient();
    }

    public boolean getSerializeTransient() {
        return this.config.isSerializeTransient();
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        int i2;
        int n2;
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        if (this.config.isCopyTransient()) {
            n2 = this.transientFields.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.transientFields[i2].copy(original, copy);
            }
        }
        n2 = this.fields.length;
        for (i2 = 0; i2 < n2; ++i2) {
            this.fields[i2].copy(original, copy);
        }
        return copy;
    }

    final Generics getGenericsScope() {
        return this.genericsScope;
    }

    static {
        block3: {
            try {
                unsafeUtilClass = FieldSerializer.class.getClassLoader().loadClass("com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.UnsafeUtil");
                Method unsafeMethod = unsafeUtilClass.getMethod("unsafe", new Class[0]);
                sortFieldsByOffsetMethod = unsafeUtilClass.getMethod("sortFieldsByOffset", List.class);
                Object unsafe = unsafeMethod.invoke(null, new Object[0]);
                if (unsafe != null) {
                    unsafeAvailable = true;
                }
            }
            catch (Throwable e2) {
                if (!Log.TRACE) break block3;
                Log.trace("kryo", "sun.misc.Unsafe is unavailable.");
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Bind {
        public Class<? extends Serializer> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static interface CachedFieldNameStrategy {
        public static final CachedFieldNameStrategy DEFAULT = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getName();
            }
        };
        public static final CachedFieldNameStrategy EXTENDED = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getDeclaringClass().getSimpleName() + "." + cachedField.field.getName();
            }
        };

        public String getName(CachedField var1);
    }

    public static interface CachedFieldFactory {
        public CachedField createCachedField(Class var1, Field var2, FieldSerializer var3);
    }

    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

