/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.HeaderDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JWTParser {
    private final ObjectReader payloadReader;
    private final ObjectReader headerReader;

    public JWTParser() {
        this(JWTParser.getDefaultObjectMapper());
    }

    JWTParser(ObjectMapper mapper) {
        this.addDeserializers(mapper);
        this.payloadReader = mapper.readerFor(Payload.class);
        this.headerReader = mapper.readerFor(Header.class);
    }

    public Payload parsePayload(String json) throws JWTDecodeException {
        if (json == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Payload)this.payloadReader.readValue(json);
        }
        catch (IOException e2) {
            throw JWTParser.decodeException(json);
        }
    }

    public Header parseHeader(String json) throws JWTDecodeException {
        if (json == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Header)this.headerReader.readValue(json);
        }
        catch (IOException e2) {
            throw JWTParser.decodeException(json);
        }
    }

    private void addDeserializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        ObjectReader reader = mapper.reader();
        module.addDeserializer(Payload.class, new PayloadDeserializer(reader));
        module.addDeserializer(Header.class, new HeaderDeserializer(reader));
        mapper.registerModule(module);
    }

    static ObjectMapper getDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    private static JWTDecodeException decodeException() {
        return JWTParser.decodeException(null);
    }

    private static JWTDecodeException decodeException(String json) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", json));
    }
}

