/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.RSAAlgorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.SignatureVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.RSAKeyProvider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public abstract class Algorithm {
    private final String name;
    private final String description;

    public static Algorithm RSA256(RSAKeyProvider keyProvider) throws IllegalArgumentException {
        return new RSAAlgorithm("RS256", "SHA256withRSA", keyProvider);
    }

    public static Algorithm RSA256(RSAPublicKey publicKey, RSAPrivateKey privateKey) throws IllegalArgumentException {
        return Algorithm.RSA256(RSAAlgorithm.providerForKeys(publicKey, privateKey));
    }

    protected Algorithm(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public abstract void verify(DecodedJWT var1) throws SignatureVerificationException;
}

