/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.annotations.VisibleForTesting;
import autovalue.shaded.com.google.common.base.Strings;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.auto.value.processor.TypeMirrorSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

class Nullables {
    static final String NULLABLE_OPTION = "com.google.auto.value.NullableTypeAnnotation";
    private static final String DEFAULT_NULLABLE = "org".concat(".jspecify.nullness.Nullable");
    private final Optional<AnnotationMirror> defaultNullable;

    Nullables(ProcessingEnvironment processingEnv) {
        String nullableOption = Strings.nullToEmpty(processingEnv.getOptions().getOrDefault(NULLABLE_OPTION, DEFAULT_NULLABLE));
        this.defaultNullable = !nullableOption.isEmpty() && processingEnv.getSourceVersion().ordinal() >= SourceVersion.RELEASE_8.ordinal() ? Optional.ofNullable(processingEnv.getElementUtils().getTypeElement(nullableOption)).map(t -> Nullables.annotationMirrorOf(MoreTypes.asDeclared(t.asType()))) : Optional.empty();
    }

    private static AnnotationMirror annotationMirrorOf(final DeclaredType annotationType) {
        return new AnnotationMirror(){

            @Override
            public DeclaredType getAnnotationType() {
                return annotationType;
            }

            public ImmutableMap<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                return ImmutableMap.of();
            }
        };
    }

    @VisibleForTesting
    static Optional<AnnotationMirror> nullableMentionedInMethods(Collection<ExecutableElement> methods) {
        return methods.stream().flatMap(method -> Stream.concat(Stream.of(method.getReturnType()), method.getParameters().stream().map(Element::asType))).map(Nullables::nullableIn).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    Optional<AnnotationMirror> appropriateNullableGivenMethods(Collection<ExecutableElement> methods) {
        return Nullables.nullableMentionedInMethods(methods).map(Optional::of).orElse(this.defaultNullable);
    }

    private static Optional<AnnotationMirror> nullableIn(TypeMirror type) {
        return (Optional)new NullableFinder().visit(type);
    }

    private static Optional<AnnotationMirror> nullableIn(List<? extends AnnotationMirror> annotations) {
        return annotations.stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")).map(a -> a).findFirst();
    }

    private static class NullableFinder
    extends SimpleTypeVisitor8<Optional<AnnotationMirror>, Void> {
        private final TypeMirrorSet visiting = new TypeMirrorSet();

        NullableFinder() {
            super(Optional.empty());
        }

        @Override
        public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void unused) {
            if (!this.visiting.add(t)) {
                return Optional.empty();
            }
            return Nullables.nullableIn(t.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(t.getTypeArguments()));
        }

        @Override
        public Optional<AnnotationMirror> visitTypeVariable(TypeVariable t, Void unused) {
            if (!this.visiting.add(t)) {
                return Optional.empty();
            }
            return Nullables.nullableIn(t.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(ImmutableList.of(t.getUpperBound(), t.getLowerBound())));
        }

        @Override
        public Optional<AnnotationMirror> visitArray(ArrayType t, Void unused) {
            return Nullables.nullableIn(t.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> (Optional)this.visit(t.getComponentType()));
        }

        @Override
        public Optional<AnnotationMirror> visitWildcard(WildcardType t, Void unused) {
            return Nullables.nullableIn(t.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(Stream.of(t.getExtendsBound(), t.getSuperBound()).filter(Objects::nonNull).collect(Collectors.toList())));
        }

        @Override
        public Optional<AnnotationMirror> visitIntersection(IntersectionType t, Void unused) {
            return Nullables.nullableIn(t.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(t.getBounds()));
        }

        private Optional<AnnotationMirror> visitAll(List<? extends TypeMirror> types) {
            return types.stream().map(this::visit).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        }
    }
}

