/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.wrapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.github.yulichang.extension.mapping.mapper.MPJMappingWrapper;
import com.github.yulichang.extension.mapping.mapper.MPJTableFieldInfo;
import java.util.List;

public class MappingQuery<T>
extends QueryWrapper<T> {
    public QueryWrapper<T> addCondition(boolean condition, String column, SqlKeyword sqlKeyword, Object val) {
        return (QueryWrapper)super.addCondition(condition, (Object)column, sqlKeyword, val);
    }

    public static <T> List<?> mpjQueryList(BaseMapper<T> baseMapper, SqlKeyword keyword, String column, Object val, MPJTableFieldInfo fieldInfo) {
        MPJMappingWrapper infoWrapper = fieldInfo.getWrapper();
        MappingQuery wrapper = new MappingQuery();
        if (infoWrapper.isHasCondition()) {
            infoWrapper.getConditionList().forEach(c -> {
                if (c.getKeyword() == SqlKeyword.BETWEEN) {
                    wrapper.between(c.getColumn(), c.getVal()[0], c.getVal()[1]);
                } else if (c.getKeyword() == SqlKeyword.IN) {
                    wrapper.in(c.getColumn(), c.getVal());
                } else {
                    wrapper.addCondition(true, c.getColumn(), c.getKeyword(), (Object)c.getVal()[0]);
                }
            });
        }
        wrapper.eq(SqlKeyword.EQ == keyword, column, val);
        if (infoWrapper.isHasFirst()) {
            wrapper.first(infoWrapper.getFirst());
        }
        if (infoWrapper.isHasOrderByAsc()) {
            infoWrapper.getOrderByAsc().forEach(arg_0 -> wrapper.orderByAsc(arg_0));
        }
        if (infoWrapper.isHasOrderByDesc()) {
            infoWrapper.getOrderByDesc().forEach(arg_0 -> wrapper.orderByDesc(arg_0));
        }
        if (infoWrapper.isHasLast()) {
            wrapper.last(infoWrapper.getLast());
        }
        if (SqlKeyword.IN == keyword) {
            wrapper.in(column, (List)val);
        }
        if (infoWrapper.isHasSelect()) {
            wrapper.select(new String[]{infoWrapper.getSelect()});
        }
        if (infoWrapper.isHasApply()) {
            infoWrapper.getApplyList().forEach(a -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper.apply(a.getSql(), a.getVal());
            });
        }
        return baseMapper.selectList(wrapper);
    }
}

