/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.relation;

import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.github.yulichang.extension.mapping.config.DeepConfig;
import com.github.yulichang.extension.mapping.mapper.MPJTableFieldInfo;
import com.github.yulichang.extension.mapping.mapper.MPJTableInfo;
import com.github.yulichang.extension.mapping.mapper.MPJTableInfoHelper;
import com.github.yulichang.extension.mapping.wrapper.MappingQuery;
import com.github.yulichang.toolkit.LambdaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Relation {
    public static <R, T> R mpjGetRelation(R r, DeepConfig<T> config) {
        int start = 1;
        if (Objects.isNull(r)) {
            return null;
        }
        if (r instanceof List) {
            List data = (List)r;
            if (CollectionUtils.isEmpty((Collection)data)) {
                return r;
            }
            Object t = data.get(0);
            if (Map.class.isAssignableFrom(t.getClass())) {
                throw ExceptionUtils.mpe((String)"\u6682\u4e0d\u652f\u6301Map\u7c7b\u578b\u6620\u5c04", (Object[])new Object[0]);
            }
            if (Object.class == t.getClass()) {
                return r;
            }
            return (R)Relation.list(data, start, config);
        }
        if (r instanceof IPage) {
            IPage data = (IPage)r;
            if (!CollectionUtils.isEmpty((Collection)data.getRecords())) {
                Object t = data.getRecords().get(0);
                if (Map.class.isAssignableFrom(t.getClass())) {
                    throw ExceptionUtils.mpe((String)"\u6682\u4e0d\u652f\u6301Map\u7c7b\u578b\u6620\u5c04", (Object[])new Object[0]);
                }
                if (Object.class == t.getClass()) {
                    return r;
                }
                Relation.list(data.getRecords(), start, config);
            }
            return r;
        }
        if (r instanceof Integer) {
            return r;
        }
        if (r instanceof Long) {
            return r;
        }
        if (r instanceof Boolean) {
            return r;
        }
        if (Object.class == r.getClass()) {
            return r;
        }
        return Relation.one(r, start, config);
    }

    public static <T> List<T> list(List<T> data, int currDeep, DeepConfig<T> config) {
        if (CollectionUtils.isEmpty(data)) {
            return data;
        }
        Class<?> entityClass = data.get(0).getClass();
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(entityClass);
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(config.getProperty());
            List listProperty = hasProperty ? config.getProperty().stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                List itemList;
                if (hasProperty) {
                    if (!listProperty.contains(fieldInfo.getProperty())) continue;
                }
                if (CollectionUtils.isNotEmpty(itemList = data.stream().map(fieldInfo::thisFieldGet).collect(Collectors.toList()))) {
                    List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), SqlKeyword.IN, fieldInfo.getJoinColumn(), itemList, fieldInfo);
                    data.forEach(i -> Relation.mpjBindData(i, fieldInfo, joinList, currDeep, config));
                    fieldInfo.removeJoinField(joinList);
                    continue;
                }
                data.forEach(i -> fieldInfo.fieldSet(i, new ArrayList()));
            }
        }
        return data;
    }

    public static <T> T one(T t, int currDeep, DeepConfig<T> config) {
        if (t == null) {
            return null;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(t.getClass());
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(config.getProperty());
            List list = hasProperty ? config.getProperty().stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                Object obj;
                if (hasProperty && !list.contains(fieldInfo.getProperty()) || (obj = fieldInfo.thisFieldGet(t)) == null) continue;
                List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), SqlKeyword.EQ, fieldInfo.getJoinColumn(), obj, fieldInfo);
                Relation.mpjBindData(t, fieldInfo, joinList, currDeep, config);
                fieldInfo.removeJoinField(joinList);
            }
        }
        return t;
    }

    public static <R, T, E> void mpjBindData(R t, MPJTableFieldInfo fieldInfo, List<?> joinList, int currDeep, DeepConfig<T> config) {
        if (currDeep >= config.getDeep()) {
            return;
        }
        if (currDeep >= config.getMaxDeep()) {
            throw ExceptionUtils.mpe((String)"\u8d85\u8fc7\u6700\u5927\u67e5\u8be2\u6df1\u5ea6", (Object[])new Object[0]);
        }
        if (fieldInfo.isMappingEntity()) {
            List list = joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).collect(Collectors.toList());
            MPJTableFieldInfo.bind(fieldInfo, t, list);
            if (config.isLoop() && CollectionUtils.isNotEmpty(list)) {
                int newCount = currDeep + 1;
                if (CollectionUtils.isNotEmpty(config.getProperty()) && LambdaUtils.getEntityClass(config.getProperty().get(0)).isAssignableFrom(list.get(0).getClass())) {
                    Relation.list(list, newCount, config);
                } else {
                    DeepConfig deepConfig = new DeepConfig();
                    deepConfig.setDeep(config.getDeep());
                    deepConfig.setLoop(config.isLoop());
                    deepConfig.setMaxDeep(config.getMaxDeep());
                    Relation.list(list, newCount, deepConfig);
                }
            }
        }
        if (fieldInfo.isMappingField()) {
            MPJTableFieldInfo.bind(fieldInfo, t, joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).map(fieldInfo::bindFieldGet).collect(Collectors.toList()));
        }
    }
}

