/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.config;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.yulichang.interceptor.MPJInterceptor;
import com.github.yulichang.toolkit.InterceptorList;
import com.github.yulichang.toolkit.MybatisJoinPlusVersion;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class MPJInterceptorConfig {
    private static final Log logger = LogFactory.getLog(MPJInterceptorConfig.class);

    public MPJInterceptorConfig(List<SqlSessionFactory> sqlSessionFactoryList, Boolean banner) {
        this.replaceInterceptorChain(sqlSessionFactoryList);
        if (banner.booleanValue()) {
            System.out.println(" _ _   |_  _ _|_. ___ _ |    _  .  _  .  _  \n| | |\\/|_)(_| | |_\\  |_)||_|_\\  | (_) | | | \n     /               |          /\n                                    " + MybatisJoinPlusVersion.getVersion());
        }
    }

    private void replaceInterceptorChain(List<SqlSessionFactory> sqlSessionFactoryList) {
        if (CollectionUtils.isEmpty(sqlSessionFactoryList)) {
            return;
        }
        for (SqlSessionFactory factory : sqlSessionFactoryList) {
            try {
                Field interceptorChain = Configuration.class.getDeclaredField("interceptorChain");
                interceptorChain.setAccessible(true);
                InterceptorChain chain = (InterceptorChain)interceptorChain.get(factory.getConfiguration());
                Field interceptors = InterceptorChain.class.getDeclaredField("interceptors");
                interceptors.setAccessible(true);
                List list = (List)interceptors.get(chain);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    interceptors.set(chain, new InterceptorList());
                } else {
                    interceptors.set(chain, new InterceptorList(list));
                }
                chain.addInterceptor((Interceptor)new MPJInterceptor());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error("\u521d\u59cb\u5316 MPJ \u62e6\u622a\u5668\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

