/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper.segments;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.toolkit.MPJStringUtils;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.toolkit.TableHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class SelectCache
implements Serializable {
    private final Class<?> clazz;
    private final boolean isPk;
    private final String column;
    private final Class<?> columnType;
    private final String tagColumn;
    private final String columProperty;
    private final boolean hasTypeHandle;
    private final Class<?> propertyType;
    private final JdbcType jdbcType;
    private final Class<? extends TypeHandler<?>> typeHandlerClass;
    private final boolean isSelect;

    public SelectCache(Class<?> clazz, boolean isPk, String column, Class<?> columnType, String columProperty, boolean isSelect, TableFieldInfo tableFieldInfo) {
        this.clazz = clazz;
        this.isPk = isPk;
        this.column = column;
        this.columnType = columnType;
        this.columProperty = columProperty;
        this.tagColumn = MPJStringUtils.getTargetColumn(column);
        this.isSelect = isSelect;
        if (Objects.isNull(tableFieldInfo)) {
            this.hasTypeHandle = false;
            this.propertyType = null;
            this.jdbcType = null;
            this.typeHandlerClass = null;
        } else {
            this.propertyType = tableFieldInfo.getPropertyType();
            this.jdbcType = tableFieldInfo.getJdbcType();
            this.typeHandlerClass = tableFieldInfo.getTypeHandler();
            this.hasTypeHandle = tableFieldInfo.getTypeHandler() != null && tableFieldInfo.getTypeHandler() != UnknownTypeHandler.class;
        }
    }

    public TypeHandler<?> getTypeHandler() {
        if (this.hasTypeHandle) {
            return Cache.getTypeHandlerCache(this.clazz, this.typeHandlerClass, this.propertyType, this.columProperty);
        }
        return null;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isPk() {
        return this.isPk;
    }

    public String getColumn() {
        return this.column;
    }

    public Class<?> getColumnType() {
        return this.columnType;
    }

    public String getTagColumn() {
        return this.tagColumn;
    }

    public String getColumProperty() {
        return this.columProperty;
    }

    public boolean isHasTypeHandle() {
        return this.hasTypeHandle;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler<?>> getTypeHandlerClass() {
        return this.typeHandlerClass;
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public static class Cache {
        private static final Map<Class<?>, Map<Class<?>, TypeHandler<?>>> CACHE = new ConcurrentHashMap();

        public static TypeHandler<?> getTypeHandlerCache(Class<?> table, Class<? extends TypeHandler<?>> typeHandler, Class<?> propertyType, String columProperty) {
            if (table == null || typeHandler == null) {
                return null;
            }
            Map map = CACHE.computeIfAbsent(table, k -> new ConcurrentHashMap());
            return map.computeIfAbsent(typeHandler, k -> {
                TableInfo info = TableHelper.getAssert(table);
                TableFieldInfo fieldInfo = info.getFieldList().stream().filter(f -> f.getProperty().equals(columProperty)).findFirst().get();
                Field field = AdapterHelper.getAdapter().mpjGetField(fieldInfo, () -> ReflectionKit.getFieldMap(table).get(columProperty));
                return AdapterHelper.getAdapter().getTypeHandler(AdapterHelper.getAdapter().mpjGetConfiguration(info), propertyType, typeHandler, field);
            });
        }
    }
}

