/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.github.yulichang.extension.apt.matedata.BaseColumn;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableMap
implements Serializable {
    private TableMap parent;
    private final BaseColumn<?> root;
    private String rootAlias;
    private final Map<BaseColumn<?>, String> tableMap = new LinkedHashMap();

    public TableMap(BaseColumn<?> root, String rootAlias) {
        this.root = root;
        this.rootAlias = rootAlias;
    }

    public String put(BaseColumn<?> key, String value) {
        return this.tableMap.put(key, value);
    }

    public String get(BaseColumn<?> key) {
        return this.get(this, key);
    }

    private String get(TableMap tableMap, BaseColumn<?> key) {
        if (null != key.getAlias()) {
            return key.getAlias();
        }
        if (key == tableMap.root) {
            return tableMap.rootAlias;
        }
        String pf = tableMap.tableMap.get(key);
        if (null == pf) {
            if (tableMap.parent == null) {
                throw ExceptionUtils.mpe((String)"table not found %s", (Object[])new Object[]{key.getColumnClass().getName()});
            }
            return this.get(tableMap.parent, key);
        }
        return pf;
    }

    public Collection<BaseColumn<?>> keyList() {
        return this.tableMap.keySet();
    }

    public boolean isEmpty() {
        return this.tableMap.isEmpty();
    }

    public void clear() {
        this.tableMap.clear();
    }

    public void setParent(TableMap parent) {
        this.parent = parent;
    }

    public TableMap getParent() {
        return this.parent;
    }

    public BaseColumn<?> getRoot() {
        return this.root;
    }

    public String getRootAlias() {
        return this.rootAlias;
    }

    public void setRootAlias(String rootAlias) {
        this.rootAlias = rootAlias;
    }
}

