/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import com.baomidou.mybatisplus.core.toolkit.support.BiIntFunction;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class MPJStringUtils {
    public static final String IS = "is";
    public static final char UNDERLINE = '_';
    public static final Pattern MP_SQL_PLACE_HOLDER = Pattern.compile("[{](?<idx>\\d+)}");
    private static final Pattern P_IS_COLUMN = Pattern.compile("^\\w\\S*[\\w\\d]*$");
    private static final Pattern CAPITAL_MODE = Pattern.compile("^[0-9A-Z/_]+$");

    public static boolean isChinese(String str) {
        if (MPJStringUtils.isBlank(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs != null) {
            int length = cs.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String toStringTrim(Object o) {
        return String.valueOf(o).trim();
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !MPJStringUtils.isBlank(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !MPJStringUtils.isEmpty(cs);
    }

    public static boolean isCamel(String str) {
        return Character.isLowerCase(str.charAt(0)) && !str.contains("_");
    }

    public static boolean isNotColumnName(String str) {
        return !P_IS_COLUMN.matcher(str).matches();
    }

    public static String getTargetColumn(String column) {
        if (MPJStringUtils.isChinese(column)) {
            return column;
        }
        if (MPJStringUtils.isNotColumnName(column)) {
            return column.substring(1, column.length() - 1);
        }
        return column;
    }

    public static String camelToUnderline(String param) {
        if (MPJStringUtils.isBlank(param)) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (MPJStringUtils.isBlank(param)) {
            return "";
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String firstToLowerCase(String param) {
        if (MPJStringUtils.isBlank(param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String sqlArgsFill(String content, Object ... args) {
        if (MPJStringUtils.isNotBlank(content) && ArrayUtils.isNotEmpty((Object[])args)) {
            BiIntFunction handler = (m, i) -> MPJStringUtils.sqlParam(args[Integer.parseInt(m.group("idx"))]);
            return MPJStringUtils.replace(content, MP_SQL_PLACE_HOLDER, (BiIntFunction<Matcher, CharSequence>)handler).toString();
        }
        return content;
    }

    public static StringBuilder replace(CharSequence src, Pattern ptn, BiIntFunction<Matcher, CharSequence> replacer) {
        int idx = 0;
        int last = 0;
        int len = src.length();
        Matcher m = ptn.matcher(src);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            sb.append(src, last, m.start()).append((CharSequence)replacer.apply((Object)m, idx++));
            last = m.end();
        }
        if (last < len) {
            sb.append(src, last, len);
        }
        return sb;
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? MPJStringUtils.quotaMarkList((Collection)obj) : MPJStringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof CharSequence) {
            return StringEscape.escapeString((String)srcStr);
        }
        return srcStr;
    }

    public static String quotaMarkList(Collection<?> coll) {
        return coll.stream().map(MPJStringUtils::quotaMark).collect(Collectors.joining(",", "(", ")"));
    }

    public static String concatCapitalize(String concatStr, String str) {
        if (MPJStringUtils.isBlank(concatStr)) {
            concatStr = "";
        }
        if (str == null || str.isEmpty()) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return concatStr + Character.toTitleCase(firstChar) + str.substring(1);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return MPJStringUtils.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !MPJStringUtils.checkValNotNull(object);
    }

    public static boolean containsUpperCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalMode(String word) {
        return null != word && CAPITAL_MODE.matcher(word).matches();
    }

    public static boolean isMixedMode(String word) {
        return MPJStringUtils.matches(".*[A-Z]+.*", word) && MPJStringUtils.matches(".*[/_]+.*", word);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean isCharSequence(Class<?> clazz) {
        return clazz != null && CharSequence.class.isAssignableFrom(clazz);
    }

    public static String prefixToLower(String rawString, int index) {
        return rawString.substring(0, index).toLowerCase() + rawString.substring(index);
    }

    public static String removePrefixAfterPrefixToLower(String rawString, int index) {
        return MPJStringUtils.prefixToLower(rawString.substring(index), 1);
    }

    public static String camelToHyphen(String input) {
        return MPJStringUtils.wordsToHyphenCase(MPJStringUtils.wordsAndHyphenAndCamelToConstantCase(input));
    }

    private static String wordsAndHyphenAndCamelToConstantCase(String input) {
        char[] chars;
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        for (char c : chars = input.toCharArray()) {
            boolean isNotUnderscore;
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(previousChar);
            boolean lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '_';
            boolean bl = isNotUnderscore = c != '_';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace)) {
                buf.append("_");
            } else if (Character.isDigit(previousChar) && Character.isLetter(c)) {
                buf.append('_');
            }
            if (MPJStringUtils.shouldReplace(c) && lastOneIsNotUnderscore) {
                buf.append('_');
            } else if (!Character.isWhitespace(c) && (isNotUnderscore || lastOneIsNotUnderscore)) {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        if (Character.isWhitespace(previousChar)) {
            buf.append("_");
        }
        return buf.toString();
    }

    private static boolean shouldReplace(char c) {
        return c == '.' || c == '_' || c == '-';
    }

    private static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append("-");
            } else if ('.' == c) {
                buf.append("-");
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

