/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.github.yulichang.toolkit.FieldStringMap;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.toolkit.support.FieldCache;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.Reflector;

public final class MPJReflectionKit {
    private static final Map<Class<?>, FieldStringMap<FieldCache>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, List<FieldCache>> CLASS_FIELD_LIST_CACHE = new ConcurrentHashMap();
    private static final Map<String, FieldCache> EMPTY_MAP = new HashMap<String, FieldCache>();
    @Deprecated
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_TO_WRAPPER_MAP = new IdentityHashMap(8);

    public static Class<?> getGenericType(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        Type argument = actualTypeArguments[0];
        if (argument instanceof WildcardType) {
            Type[] types = ((WildcardType)argument).getUpperBounds();
            return (Class)types[0];
        }
        return (Class)argument;
    }

    public static Map<String, FieldCache> getFieldMap(Class<?> clazz) {
        return CLASS_FIELD_CACHE.computeIfAbsent(clazz, key -> MPJReflectionKit.getFieldList(key).stream().collect(Collectors.toMap(f -> f.getField().getName().toUpperCase(Locale.ENGLISH), Function.identity(), (o, n) -> n, FieldStringMap::new)));
    }

    public static List<FieldCache> getFieldList(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        List<FieldCache> fieldList = CLASS_FIELD_LIST_CACHE.get(clazz);
        if (fieldList != null) {
            return fieldList;
        }
        List<Field> list = ReflectionKit.getFieldList(clazz);
        List<FieldCache> cache = list.stream().map(f -> {
            FieldCache fieldCache = new FieldCache();
            fieldCache.setField((Field)f);
            try {
                Reflector reflector = new Reflector(clazz);
                Class<?> getterType = reflector.getGetterType(f.getName());
                fieldCache.setType(Objects.isNull(getterType) ? f.getType() : getterType);
            }
            catch (Throwable throwable) {
                fieldCache.setType(f.getType());
            }
            return fieldCache;
        }).collect(Collectors.toList());
        CLASS_FIELD_LIST_CACHE.put(clazz, cache);
        return cache;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null", (Object[])new Object[0]);
        return clazz.isPrimitive() || PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(clazz);
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(String.class, String.class);
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_WRAPPER_TYPE_MAP.entrySet()) {
            PRIMITIVE_TYPE_TO_WRAPPER_MAP.put(entry.getValue(), entry.getKey());
        }
    }
}

