/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor.pagination;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.github.yulichang.interceptor.pagination.SqlSourceWrapper;
import com.github.yulichang.toolkit.ReflectionKit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public final class ParseHelper {
    private static final Map<SqlSource, SqlSourceWrapper> SQL_SOURCE_CACHE = new ConcurrentHashMap<SqlSource, SqlSourceWrapper>();
    private static final String prefix = "MPJ_Param_i_";
    private static final String suffix = "_MPJ_Param_i";
    private static final char placeholder_char = '?';
    private static final String placeholder_str = String.valueOf('?');
    public static final Function<Object, String> format = index -> prefix + index + suffix;

    public static int countChar(String str) {
        return ParseHelper.countChar(str, '?');
    }

    public static int countChar(String str, String tag) {
        return ParseHelper.countChar(str, tag.charAt(0));
    }

    public static int countChar(String str, char tag) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != tag) continue;
            ++count;
        }
        return count;
    }

    public static String decode(String str) {
        return ParseHelper.decode(str, null);
    }

    public static String decode(String str, Function<Object, String> formatter) {
        return ParseHelper.decode(str, formatter, '?');
    }

    public static String decode(String str, Function<Object, String> formatter, char placeholder) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == placeholder) {
                sb.append(format.apply(formatter == null ? Integer.valueOf(count) : formatter.apply(count)));
                ++count;
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String decode(String str, Function<Object, String> formatter, String placeholder) {
        StringBuilder sb = new StringBuilder();
        String[] split = str.split(placeholder);
        for (int i = 0; i < split.length; ++i) {
            sb.append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append(format.apply(formatter == null ? Integer.valueOf(i) : formatter.apply(i)));
        }
        return sb.toString();
    }

    public static String encode(List<ParameterMapping> mappings, int count, String repSql, Map<Integer, ParameterMapping> sortMap) {
        return ParseHelper.encode(mappings, count, repSql, sortMap, placeholder_str);
    }

    public static String encode(List<ParameterMapping> mappings, int count, String repSql, Map<Integer, ParameterMapping> sortMap, String placeholder) {
        for (int i = 0; i < count; ++i) {
            String repStr = format.apply(i);
            int i1 = repSql.indexOf(repStr);
            if (i1 == -1) continue;
            repSql = repSql.replace(repStr, placeholder);
            sortMap.put(i1, mappings.get(i));
        }
        return repSql;
    }

    public static String getOriginalSql(Object parameter, DynamicSqlSource sqlSource) {
        Assert.notNull((Object)sqlSource, (String)"sqlSource must not be null", (Object[])new Object[0]);
        SqlSourceWrapper sqlSourceWrapper = SQL_SOURCE_CACHE.computeIfAbsent((SqlSource)sqlSource, key -> {
            Configuration configuration = (Configuration)ReflectionKit.getFieldValue(sqlSource, "configuration");
            SqlNode sqlNode = (SqlNode)ReflectionKit.getFieldValue(sqlSource, "rootSqlNode");
            return new SqlSourceWrapper(configuration, sqlNode);
        });
        return ParseHelper.decode(sqlSourceWrapper.getSql(parameter), null, format.apply(""));
    }
}

