/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.apt;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.config.enums.LogicDelTypeEnum;
import com.github.yulichang.extension.apt.JoinAbstractWrapper;
import com.github.yulichang.extension.apt.interfaces.QueryJoin;
import com.github.yulichang.extension.apt.matedata.BaseColumn;
import com.github.yulichang.extension.apt.matedata.Column;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.TableMap;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.interfaces.MFunction;
import com.github.yulichang.wrapper.segments.PageInfo;
import com.github.yulichang.wrapper.segments.SelectCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public abstract class AptAbstractWrapper<T, Children extends AptAbstractWrapper<T, Children>>
extends JoinAbstractWrapper<T, Children>
implements QueryJoin<Children, T> {
    protected String alias = ConfigProperties.tableAlias;
    protected String subTableAlias = ConfigProperties.tableAlias;
    protected boolean resultMap = false;
    protected boolean resultMapCollection = false;
    protected PageInfo pageInfo;
    protected boolean pageByMain = false;
    protected int tableIndex = 1;
    protected boolean isMain = true;
    protected boolean dynamicTableName = false;
    protected SFunction<String, String> tableFunc;
    protected LogicDelTypeEnum logicDelType = ConfigProperties.logicDelType;
    protected final SharedString from = new SharedString();
    protected boolean hasAlias;
    protected String keyWord;
    protected boolean subLogicSql = ConfigProperties.subTableLogic;
    protected boolean logicSql = true;
    protected BaseColumn<T> baseColumn;
    protected TableMap aptIndex;

    protected AptAbstractWrapper(BaseColumn<T> baseColumn) {
        this.alias = StringUtils.isNotBlank((CharSequence)baseColumn.getAlias()) ? baseColumn.getAlias() : this.alias;
        this.setEntityClass(baseColumn.getColumnClass());
        this.baseColumn = baseColumn;
        this.initNeed();
    }

    protected AptAbstractWrapper(BaseColumn<T> baseColumn, T entity) {
        this.alias = StringUtils.isNotBlank((CharSequence)baseColumn.getAlias()) ? baseColumn.getAlias() : this.alias;
        this.setEntity(entity);
        this.baseColumn = baseColumn;
        this.initNeed();
    }

    public Children pageByMain() {
        this.pageByMain = true;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public Children pageByMain(MFunction<PageInfo> function) {
        this.pageByMain = true;
        function.apply(this.getPageInfo());
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public PageInfo getPageInfo() {
        if (this.pageInfo == null) {
            this.pageInfo = new PageInfo();
        }
        return this.pageInfo;
    }

    public Children setTableName(SFunction<String, String> tableFunc) {
        if (this.isMain) {
            if (tableFunc != null) {
                this.dynamicTableName = true;
                this.tableFunc = tableFunc;
            }
        } else {
            this.tableName = (String)tableFunc.apply((Object)this.tableName);
        }
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public String getTableName(String tableName) {
        if (this.isMain) {
            if (this.dynamicTableName) {
                return (String)this.tableFunc.apply((Object)tableName);
            }
            return tableName;
        }
        return super.getTableName();
    }

    public String getTableNameEnc(String tableName) {
        String decode;
        TableInfo tableInfo;
        Class entityClass = this.getEntityClass();
        if (entityClass != null && (tableInfo = TableHelper.get(entityClass)) != null) {
            if (this.dynamicTableName) {
                return (String)this.tableFunc.apply((Object)tableInfo.getTableName());
            }
            return tableInfo.getTableName();
        }
        try {
            decode = URLDecoder.decode(tableName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.dynamicTableName) {
            return (String)this.tableFunc.apply((Object)decode);
        }
        return decode;
    }

    @Override
    protected String columnsToString(Column ... columns) {
        return Arrays.stream(columns).map(this::columnToString).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(Column column) {
        String pf = column.getAlias().get();
        if (Objects.nonNull(pf)) {
            return pf + "." + this.getCache(column).getColumn();
        }
        return this.aptIndex.get(column.getRoot()) + "." + this.getCache(column).getColumn();
    }

    protected SelectCache getCache(Column fn) {
        Map<String, SelectCache> cacheMap = ColumnCache.getMapField(fn.getClazz());
        return cacheMap.get(fn.getProperty());
    }

    public Children disableSubLogicDel() {
        this.subLogicSql = false;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public Children enableSubLogicDel() {
        this.subLogicSql = true;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public Children disableLogicDel() {
        this.logicSql = false;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public Children enableLogicDel() {
        this.logicSql = true;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public String getSubLogicSql() {
        if (this.subLogicSql && this.logicDelType == LogicDelTypeEnum.WHERE) {
            if (this.aptIndex.isEmpty()) {
                return "";
            }
            return this.aptIndex.keyList().stream().map(key -> LogicInfoUtils.getLogicInfoApt(key.getColumnClass(), this.aptIndex.get((BaseColumn<?>)key))).collect(Collectors.joining(" "));
        }
        return "";
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    public Children logicDelToOn() {
        this.logicDelType = LogicDelTypeEnum.ON;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public Children logicDelToWhere() {
        this.logicDelType = LogicDelTypeEnum.WHERE;
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (AptAbstractWrapper wrapper : this.onWrappers) {
                if (StringUtils.isBlank((CharSequence)wrapper.from.getStringValue())) {
                    if (this.subLogicSql && this.logicDelType == LogicDelTypeEnum.ON) {
                        TableInfo tableInfo = TableHelper.getAssert(wrapper.getJoinClass());
                        if (AdapterHelper.getAdapter().mpjHasLogic(tableInfo)) {
                            wrapper.appendSqlSegments(new ISqlSegment[]{WrapperKeyword.APPLY, (ISqlSegment & Serializable)() -> LogicInfoUtils.getLogicInfoNoAnd(wrapper.getIndex(), wrapper.getJoinClass(), wrapper.isHasAlias(), wrapper.getAlias())});
                        }
                    }
                    value.append(" ").append(wrapper.getKeyWord()).append(" ").append(wrapper.getTableName()).append(" ").append(wrapper.hasAlias ? wrapper.alias : wrapper.alias + wrapper.getIndex()).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
                    continue;
                }
                value.append(" ").append(wrapper.getKeyWord()).append(" ").append(wrapper.from.getStringValue()).append(" ");
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    public boolean checkJoinTable(Class<?> clazz) {
        return this.onWrappers.stream().anyMatch(wrapper -> {
            if (Objects.equals(wrapper.getJoinClass(), clazz)) {
                return true;
            }
            TableInfo info = TableHelper.getAssert(clazz);
            String tableName = info.getTableName();
            return Optional.ofNullable(wrapper.from.getStringValue()).map(w -> w.contains("JOIN " + tableName + " ")).orElse(false);
        });
    }

    @Override
    public <R> Children join(String keyWord, BaseColumn<R> baseColumn, MFunction<AptAbstractWrapper<T, ?>> function) {
        Integer oldIndex = this.getIndex();
        int newIndex = this.tableIndex;
        TableInfo info = TableHelper.getAssert(baseColumn.getColumnClass());
        AptAbstractWrapper instance = (AptAbstractWrapper)this.instance(newIndex, keyWord, baseColumn.getColumnClass(), info.getTableName());
        instance.isMain = false;
        this.onWrappers.add(instance);
        if (StringUtils.isBlank((CharSequence)baseColumn.getAlias())) {
            this.aptIndex.put(baseColumn, this.subTableAlias + newIndex);
            instance.alias = this.subTableAlias;
            instance.hasAlias = false;
        } else {
            this.aptIndex.put(baseColumn, baseColumn.getAlias());
            instance.alias = baseColumn.getAlias();
            instance.hasAlias = true;
        }
        ++this.tableIndex;
        function.apply(instance);
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    @Override
    public Children join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            AptAbstractWrapper wrapper = (AptAbstractWrapper)this.instanceEmpty();
            wrapper.from.setStringValue(joinSql);
            wrapper.keyWord = keyWord;
            this.onWrappers.add(wrapper);
        }
        return (Children)((AptAbstractWrapper)this.typedThis);
    }

    public boolean isUseAnnotationOrderBy() {
        String _sqlSegment = this.getSqlSegment();
        if (StringUtils.isBlank((CharSequence)_sqlSegment)) {
            return true;
        }
        String _sqlSegmentToUpperCase = _sqlSegment.toUpperCase();
        return !_sqlSegmentToUpperCase.contains("ORDER BY") && !_sqlSegmentToUpperCase.contains("LIMIT");
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
        this.aptIndex = new TableMap(this.baseColumn, this.alias);
    }

    @Override
    public void clear() {
        super.clear();
        this.alias = ConfigProperties.tableAlias;
        this.resultMap = false;
        this.resultMapCollection = false;
        this.pageInfo = null;
        this.pageByMain = false;
        this.tableIndex = 1;
        this.dynamicTableName = false;
        this.tableFunc = null;
        this.logicDelType = ConfigProperties.logicDelType;
        this.from.toEmpty();
        this.hasAlias = false;
        this.keyWord = null;
        this.logicSql = true;
        this.isMain = true;
        this.checkSqlInjection = false;
        this.onWrappers.clear();
        this.aptIndex.clear();
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isResultMap() {
        return this.resultMap;
    }

    public boolean isResultMapCollection() {
        return this.resultMapCollection;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public boolean isPageByMain() {
        return this.pageByMain;
    }

    public boolean isHasAlias() {
        return this.hasAlias;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public BaseColumn<T> getBaseColumn() {
        return this.baseColumn;
    }

    public TableMap getAptIndex() {
        return this.aptIndex;
    }
}

