/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.adapter;

import com.baomidou.mybatisplus.core.MybatisPlusVersion;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.github.yulichang.adapter.Adapter;
import com.github.yulichang.adapter.base.IAdapter;
import com.github.yulichang.adapter.base.tookit.VersionUtils;
import com.github.yulichang.adapter.v33x.Adapter33x;
import com.github.yulichang.adapter.v3431.Adapter3431;
import com.github.yulichang.adapter.v355.Adapter355;
import java.util.Optional;

public class AdapterHelper {
    private static IAdapter adapter;

    public static void setAdapter(IAdapter adapter) {
        AdapterHelper.adapter = adapter;
    }

    public static IAdapter getAdapter() {
        return adapter;
    }

    static {
        String lastAdapter = "3.5.7";
        String version = Optional.ofNullable(MybatisPlusVersion.getVersion()).orElse(lastAdapter);
        if (VersionUtils.compare((String)version, (String)"3.5.6") >= 0) {
            adapter = new Adapter();
        } else if (VersionUtils.compare((String)version, (String)"3.5.4") >= 0) {
            adapter = new Adapter355();
        } else if (VersionUtils.compare((String)version, (String)"3.4.0") >= 0) {
            adapter = new Adapter3431();
        } else if (VersionUtils.compare((String)version, (String)"3.3.0") >= 0) {
            adapter = new Adapter33x();
        } else {
            throw ExceptionUtils.mpe((String)"MPJ\u9700\u8981MP\u7248\u672c3.3.0+\uff0c\u5f53\u524dMP\u7248\u672c%s", (Object[])new Object[]{version});
        }
    }
}

