/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.query;

import com.baomidou.mybatisplus.core.MybatisPlusVersion;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.adapter.base.tookit.VersionUtils;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.query.MPJLambdaQueryWrapper;
import com.github.yulichang.query.interfaces.StringJoin;
import com.github.yulichang.toolkit.Asserts;
import com.github.yulichang.toolkit.MPJSqlInjectionUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.wrapper.interfaces.Chain;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJQueryWrapper<T>
extends AbstractWrapper<T, String, MPJQueryWrapper<T>>
implements Query<MPJQueryWrapper<T>, T, String>,
StringJoin<MPJQueryWrapper<T>, T>,
Chain<T> {
    private SharedString sqlSelect;
    private SharedString from;
    private String alias;
    private List<String> selectColumns;
    private List<String> ignoreColumns;
    private boolean selectDistinct;
    private boolean logicSql;
    private Function<String, String> tableNameFunc;
    private boolean checkSqlInjection;

    public MPJQueryWrapper() {
        this.sqlSelect = new SharedString();
        this.from = SharedString.emptyString();
        this.alias = ConfigProperties.tableAlias;
        this.selectColumns = new ArrayList<String>();
        this.ignoreColumns = new ArrayList<String>();
        this.selectDistinct = false;
        this.logicSql = true;
        this.checkSqlInjection = false;
    }

    public MPJQueryWrapper(Class<T> clazz) {
        block2: {
            this.sqlSelect = new SharedString();
            this.from = SharedString.emptyString();
            this.alias = ConfigProperties.tableAlias;
            this.selectColumns = new ArrayList<String>();
            this.ignoreColumns = new ArrayList<String>();
            this.selectDistinct = false;
            this.logicSql = true;
            this.checkSqlInjection = false;
            try {
                super.setEntityClass(clazz);
            }
            catch (NoSuchMethodError error) {
                if (VersionUtils.compare((String)MybatisPlusVersion.getVersion(), (String)"3.3.0") <= 0) break block2;
                throw error;
            }
        }
        super.initNeed();
    }

    public MPJQueryWrapper(T entity) {
        this.sqlSelect = new SharedString();
        this.from = SharedString.emptyString();
        this.alias = ConfigProperties.tableAlias;
        this.selectColumns = new ArrayList<String>();
        this.ignoreColumns = new ArrayList<String>();
        this.selectDistinct = false;
        this.logicSql = true;
        this.checkSqlInjection = false;
        super.setEntity(entity);
        super.initNeed();
    }

    public MPJQueryWrapper(T entity, Class<T> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString sqlSelect, SharedString from, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, List<String> selectColumns, List<String> ignoreColumns, boolean selectDistinct) {
        this.sqlSelect = new SharedString();
        this.from = SharedString.emptyString();
        this.alias = ConfigProperties.tableAlias;
        this.selectColumns = new ArrayList<String>();
        this.ignoreColumns = new ArrayList<String>();
        this.selectDistinct = false;
        this.logicSql = true;
        this.checkSqlInjection = false;
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.from = from;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.selectColumns = selectColumns;
        this.ignoreColumns = ignoreColumns;
        this.selectDistinct = selectDistinct;
    }

    public MPJQueryWrapper<T> checkSqlInjection() {
        this.checkSqlInjection = true;
        return this;
    }

    protected String columnToString(String column) {
        if (this.checkSqlInjection && MPJSqlInjectionUtils.check(column)) {
            throw new MybatisPlusException("Discovering SQL injection column: " + column);
        }
        return column;
    }

    public MPJQueryWrapper<T> distinct() {
        this.selectDistinct = true;
        return (MPJQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> select(String ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.selectColumns.addAll(Arrays.asList(columns));
        }
        return (MPJQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> select(boolean condition, List<String> columns) {
        if (condition && CollectionUtils.isNotEmpty(columns)) {
            this.selectColumns.addAll(columns);
        }
        return (MPJQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> selectIgnore(String ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.ignoreColumns.addAll(Arrays.asList(columns));
        }
        return (MPJQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableHelper.get(entityClass);
        Asserts.hasTable(info, entityClass);
        this.selectColumns.addAll(info.getFieldList().stream().filter(predicate).map(c -> this.alias + "." + c.getSqlSelect()).collect(Collectors.toList()));
        return (MPJQueryWrapper)this.typedThis;
    }

    public final MPJQueryWrapper<T> selectAll(Class<T> clazz) {
        this.selectAll(clazz, this.alias);
        return (MPJQueryWrapper)this.typedThis;
    }

    public final MPJQueryWrapper<T> selectAll(Class<?> clazz, String as) {
        TableInfo info = TableHelper.get(clazz);
        Asserts.hasTable(info, clazz);
        if (ConfigProperties.tableInfoAdapter.mpjHasPK(info)) {
            this.selectColumns.add(as + "." + info.getKeySqlSelect());
        }
        this.selectColumns.addAll(info.getFieldList().stream().map(i -> as + "." + i.getSqlSelect()).collect(Collectors.toList()));
        return (MPJQueryWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(this.ignoreColumns::contains);
            }
            this.sqlSelect.setStringValue(String.join((CharSequence)",", this.selectColumns));
        }
        return this.sqlSelect.getStringValue();
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    public String getFrom() {
        return this.from.getStringValue();
    }

    public MPJQueryWrapper<T> setAlias(String alias) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)alias), (String)"\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.alias = alias;
        return this;
    }

    public String getSubLogicSql() {
        return "";
    }

    public MPJQueryWrapper<T> disableLogicDel() {
        this.logicSql = false;
        return (MPJQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> enableLogicDel() {
        this.logicSql = true;
        return (MPJQueryWrapper)this.typedThis;
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    public MPJQueryWrapper<T> setTableName(Function<String, String> func) {
        this.tableNameFunc = func;
        return (MPJQueryWrapper)this.typedThis;
    }

    public String getTableName(String tableName) {
        if (this.tableNameFunc == null) {
            return tableName;
        }
        return this.tableNameFunc.apply(tableName);
    }

    public String getTableNameEnc(String tableName) {
        String decode;
        try {
            decode = URLDecoder.decode(tableName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            decode = tableName;
        }
        if (this.tableNameFunc == null) {
            return decode;
        }
        return this.tableNameFunc.apply(decode);
    }

    public MPJLambdaQueryWrapper<T> lambda() {
        return new MPJLambdaQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), this.from, this.sqlSelect, this.paramNameSeq, this.paramNameValuePairs, this.expression, this.lastSql, this.sqlComment, this.sqlFirst, this.selectColumns, this.ignoreColumns, this.selectDistinct);
    }

    protected MPJQueryWrapper<T> instance() {
        return new MPJQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), null, null, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), null, null, this.selectDistinct);
    }

    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.ignoreColumns.clear();
    }

    @Override
    public MPJQueryWrapper<T> join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            this.from.setStringValue(this.from.getStringValue() + " " + keyWord + " " + joinSql);
        }
        return (MPJQueryWrapper)this.typedThis;
    }

    public String getAlias() {
        return this.alias;
    }
}

