/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.TableList;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.interfaces.Query;
import com.github.yulichang.wrapper.interfaces.QueryJoin;
import com.github.yulichang.wrapper.interfaces.QueryLabel;
import com.github.yulichang.wrapper.resultmap.MybatisLabel;
import com.github.yulichang.wrapper.segments.Select;
import com.github.yulichang.wrapper.segments.SelectCache;
import com.github.yulichang.wrapper.segments.SelectNormal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements Query<MPJLambdaWrapper<T>>,
QueryJoin<MPJLambdaWrapper<T>, T>,
QueryLabel<MPJLambdaWrapper<T>> {
    private final SharedString from = new SharedString();
    private final List<Select> selectColumns = new ArrayList<Select>();
    private final List<MybatisLabel<?, ?>> resultMapMybatisLabel = new ArrayList();
    private boolean hasAlias;
    private SharedString sqlSelect = new SharedString();
    private boolean selectDistinct = false;
    private String keyWord;
    private boolean subLogicSql = ConfigProperties.subTableLogic;
    private boolean logicSql = true;

    public MPJLambdaWrapper() {
    }

    public MPJLambdaWrapper(Class<T> clazz) {
        this.setEntityClass(clazz);
        this.tableList.setRootClass(clazz);
    }

    public MPJLambdaWrapper(String alias) {
        this.alias = alias;
        this.tableList.setAlias(alias);
    }

    public MPJLambdaWrapper(Class<T> clazz, String alias) {
        this.alias = alias;
        this.setEntityClass(clazz);
        this.tableList.setAlias(alias);
        this.tableList.setRootClass(clazz);
    }

    MPJLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, TableList tableList, Integer index, String keyWord, Class<?> joinClass) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.tableList = tableList;
        this.index = index;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
    }

    public MPJLambdaWrapper<T> distinct() {
        this.selectDistinct = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public List<Select> getSelectColum() {
        return this.selectColumns;
    }

    @Override
    public void addLabel(MybatisLabel<?, ?> label) {
        this.resultMap = true;
        this.resultMapMybatisLabel.add(label);
    }

    @Override
    public MPJLambdaWrapper<T> getChildren() {
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    @SafeVarargs
    public final <E> MPJLambdaWrapper<T> select(SFunction<E, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            Class<E> aClass = LambdaUtils.getEntityClass(columns[0]);
            Map<String, SelectCache> cacheMap = ColumnCache.getMapField(aClass);
            for (SFunction<E, ?> s : columns) {
                SelectCache cache = cacheMap.get(LambdaUtils.getName(s));
                this.getSelectColum().add(new SelectNormal(cache, this.index, this.hasAlias, this.alias));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue()) && CollectionUtils.isNotEmpty(this.selectColumns)) {
            String s = this.selectColumns.stream().map(i -> {
                if (i.isStr()) {
                    return i.getColumn();
                }
                String prefix = i.isHasTableAlias() ? i.getTableAlias() : (i.isLabel() ? (i.isHasTableAlias() ? i.getTableAlias() : this.tableList.getPrefix(i.getIndex(), i.getClazz(), true)) : this.tableList.getPrefix(i.getIndex(), i.getClazz(), false));
                String str = prefix + "." + i.getColumn();
                if (i.isFunc()) {
                    SFunction<?, ?>[] args = i.getArgs();
                    if (Objects.isNull(args) || args.length == 0) {
                        return String.format(i.getFunc().getSql(), str) + " AS " + i.getAlias();
                    }
                    return String.format(i.getFunc().getSql(), Arrays.stream(args).map(arg -> {
                        Class entityClass = LambdaUtils.getEntityClass(arg);
                        String prefixByClass = this.tableList.getPrefixByClass(entityClass);
                        Map<String, SelectCache> mapField = ColumnCache.getMapField(entityClass);
                        SelectCache cache = mapField.get(LambdaUtils.getName(arg));
                        return prefixByClass + "." + cache.getColumn();
                    }).toArray()) + " AS " + i.getAlias();
                }
                return i.isHasAlias() ? str + " AS " + i.getAlias() : str;
            }).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (MPJLambdaWrapper wrapper : this.onWrappers) {
                if (StringUtils.isBlank((CharSequence)wrapper.from.getStringValue())) {
                    TableInfo info = TableHelper.get(wrapper.getJoinClass());
                    Assert.notNull((Object)info, (String)"table not find by class <%s>", (Object[])new Object[]{wrapper.getJoinClass().getSimpleName()});
                    String tableName = info.getTableName();
                    value.append(" ").append(wrapper.getKeyWord()).append(" ").append(tableName).append(" ").append(wrapper.hasAlias ? wrapper.alias : wrapper.alias + wrapper.getIndex()).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
                    continue;
                }
                value.append(" ").append(wrapper.getKeyWord()).append(" ").append(wrapper.from.getStringValue()).append(" ");
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return this.instance(this.index, null, null);
    }

    protected MPJLambdaWrapper<T> instance(Integer index, String keyWord, Class<?> joinClass) {
        return new MPJLambdaWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.tableList, index, keyWord, joinClass);
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.tableList.clear();
    }

    public MPJLambdaWrapper<T> disableSubLogicDel() {
        this.subLogicSql = false;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> enableSubLogicDel() {
        this.subLogicSql = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> disableLogicDel() {
        this.logicSql = false;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> enableLogicDel() {
        this.logicSql = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public String getSubLogicSql() {
        if (this.subLogicSql) {
            if (this.tableList.getAll().isEmpty()) {
                return "";
            }
            return this.tableList.getAll().stream().map(t -> LogicInfoUtils.getLogicInfo(t.getIndex(), t.getClazz(), t.isHasAlias(), t.getAlias())).collect(Collectors.joining(" "));
        }
        return "";
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    @Override
    public <R> MPJLambdaWrapper<T> join(String keyWord, Class<R> clazz, String tableAlias, BiConsumer<MPJAbstractLambdaWrapper<T, ?>, MPJLambdaWrapper<T>> consumer) {
        Integer oldIndex = this.getIndex();
        int newIndex = this.tableIndex;
        MPJLambdaWrapper<T> instance = this.instance(newIndex, keyWord, clazz);
        instance.isNo = true;
        this.onWrappers.add(instance);
        if (StringUtils.isBlank((CharSequence)tableAlias)) {
            this.tableList.put(oldIndex, clazz, false, ConfigProperties.tableAlias, newIndex);
            instance.alias = ConfigProperties.tableAlias;
            instance.hasAlias = false;
        } else {
            this.tableList.put(oldIndex, clazz, true, tableAlias, newIndex);
            instance.alias = tableAlias;
            instance.hasAlias = true;
        }
        ++this.tableIndex;
        this.index = newIndex;
        boolean isM = this.isMain;
        this.isMain = false;
        consumer.accept((MPJAbstractLambdaWrapper<MPJLambdaWrapper<T>, ?>)instance, (MPJLambdaWrapper<MPJLambdaWrapper<T>>)this.typedThis);
        this.isMain = isM;
        this.index = oldIndex;
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            MPJLambdaWrapper<T> wrapper = new MPJLambdaWrapper<T>();
            wrapper.from.setStringValue(joinSql);
            wrapper.keyWord = keyWord;
            this.onWrappers.add(wrapper);
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public List<Select> getSelectColumns() {
        return this.selectColumns;
    }

    public List<MybatisLabel<?, ?>> getResultMapMybatisLabel() {
        return this.resultMapMybatisLabel;
    }

    @Override
    public boolean isHasAlias() {
        return this.hasAlias;
    }

    public String getKeyWord() {
        return this.keyWord;
    }
}

