/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.MPJAbstractWrapper;
import com.github.yulichang.wrapper.interfaces.Query;
import com.github.yulichang.wrapper.interfaces.QueryJoin;
import com.github.yulichang.wrapper.interfaces.QueryLabel;
import com.github.yulichang.wrapper.resultmap.MybatisLabel;
import com.github.yulichang.wrapper.segments.Select;
import com.github.yulichang.wrapper.segments.SelectCache;
import com.github.yulichang.wrapper.segments.SelectNormal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements Query<MPJLambdaWrapper<T>>,
QueryJoin<MPJLambdaWrapper<T>, T>,
QueryLabel<MPJLambdaWrapper<T>> {
    private final SharedString from = new SharedString();
    private final List<Select> selectColumns = new ArrayList<Select>();
    private final List<MybatisLabel<?, ?>> resultMapMybatisLabel = new ArrayList();
    private boolean hasAlias;
    private SharedString sqlSelect = new SharedString();
    private boolean selectDistinct = false;
    private String keyWord;
    private boolean subLogicSql = ConfigProperties.subTableLogic;
    private boolean logicSql = true;

    public MPJLambdaWrapper() {
    }

    public MPJLambdaWrapper(Class<T> clazz) {
        this.setEntityClass(clazz);
    }

    public MPJLambdaWrapper(String alias) {
        this.alias = alias;
    }

    public MPJLambdaWrapper(Class<T> clazz, String alias) {
        this.alias = alias;
        this.setEntityClass(clazz);
    }

    MPJLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, MPJAbstractLambdaWrapper.TableList tableList, String index, String keyWord, Class<?> joinClass, MPJAbstractWrapper.Node node) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.tableList = tableList;
        this.index = index;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
        this.node = node;
    }

    public MPJLambdaWrapper<T> distinct() {
        this.selectDistinct = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public List<Select> getSelectColum() {
        return this.selectColumns;
    }

    @Override
    public void addLabel(MybatisLabel<?, ?> label) {
        this.resultMap = true;
        this.resultMapMybatisLabel.add(label);
    }

    @Override
    public MPJLambdaWrapper<T> getChildren() {
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    @SafeVarargs
    public final <E> MPJLambdaWrapper<T> select(SFunction<E, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            Class<E> aClass = LambdaUtils.getEntityClass(columns[0]);
            Map<String, SelectCache> cacheMap = ColumnCache.getMapField(aClass);
            for (SFunction<E, ?> s : columns) {
                SelectCache cache = cacheMap.get(LambdaUtils.getName(s));
                this.getSelectColum().add(new SelectNormal(cache, this.index));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue()) && CollectionUtils.isNotEmpty(this.selectColumns)) {
            String s = this.selectColumns.stream().map(i -> {
                if (i.isStr()) {
                    return i.getColumn();
                }
                MPJAbstractLambdaWrapper.Table t = this.tableList.get(i.getClazz());
                String str = t.isHasAlias() ? t.getAlias() + "." + i.getColumn() : (i.isLabel() && Objects.nonNull(i.getIndex()) ? i.getIndex() + "." + i.getColumn() : t.getAlias() + this.getDefaultSelect(i.getIndex(), i.getClazz(), (Select)i) + "." + i.getColumn());
                if (i.isFunc()) {
                    SFunction<?, ?>[] args = i.getArgs();
                    if (Objects.isNull(args) || args.length == 0) {
                        return String.format(i.getFunc().getSql(), str) + " AS " + i.getAlias();
                    }
                    return String.format(i.getFunc().getSql(), Arrays.stream(args).map(arg -> {
                        Class entityClass = LambdaUtils.getEntityClass(arg);
                        MPJAbstractLambdaWrapper.Table table = this.tableList.getPositive(entityClass);
                        Assert.notNull((Object)table, (String)"table not find by class <%s>", (Object[])new Object[]{entityClass.getSimpleName()});
                        Map<String, SelectCache> mapField = ColumnCache.getMapField(entityClass);
                        SelectCache cache = mapField.get(LambdaUtils.getName(arg));
                        return this.tableList.get(cache.getClazz()).getAlias() + (Objects.isNull(table.getIndex()) ? "" : table.getIndex()) + "." + cache.getColumn();
                    }).toArray()) + " AS " + i.getAlias();
                }
                return i.isHasAlias() ? str + " AS " + i.getAlias() : str;
            }).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (MPJLambdaWrapper wrapper : this.onWrappers) {
                if (StringUtils.isBlank((CharSequence)wrapper.from.getStringValue())) {
                    TableInfo info = TableInfoHelper.getTableInfo(wrapper.getJoinClass());
                    Assert.notNull((Object)info, (String)"table not find by class <%s>", (Object[])new Object[]{wrapper.getJoinClass().getSimpleName()});
                    String tableName = info.getTableName();
                    value.append(" ").append(wrapper.getKeyWord()).append(" ").append(tableName).append(" ").append(wrapper.hasAlias ? wrapper.alias : wrapper.alias + this.tableList.get(wrapper.getJoinClass(), wrapper.getIndex()).getIndex()).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
                    continue;
                }
                value.append("").append(wrapper.getKeyWord()).append("").append(wrapper.from.getStringValue()).append("");
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return this.instance(this.index, null, null, this.node);
    }

    protected MPJLambdaWrapper<T> instance(String index, String keyWord, Class<?> joinClass, MPJAbstractWrapper.Node node) {
        return new MPJLambdaWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.tableList, index, keyWord, joinClass, node);
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.tableList.clear();
    }

    public MPJLambdaWrapper<T> disableSubLogicDel() {
        this.subLogicSql = false;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> enableSubLogicDel() {
        this.subLogicSql = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> disableLogicDel() {
        this.logicSql = false;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public MPJLambdaWrapper<T> enableLogicDel() {
        this.logicSql = true;
        return (MPJLambdaWrapper)this.typedThis;
    }

    public String getSubLogicSql() {
        if (this.subLogicSql) {
            if (this.tableList.isEmpty()) {
                return "";
            }
            return this.tableList.stream().map(t -> LogicInfoUtils.getLogicInfo(t.getIndex(), t.getClazz(), t.isHasAlias(), t.getAlias())).collect(Collectors.joining(" "));
        }
        return "";
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    @Override
    public <R> MPJLambdaWrapper<T> join(String keyWord, Class<R> clazz, String tableAlias, BiConsumer<MPJAbstractLambdaWrapper<T, ?>, MPJLambdaWrapper<T>> consumer) {
        String oldIndex = this.getIndex();
        String newIndex = String.valueOf(this.tableIndex);
        MPJAbstractWrapper.Node n = Objects.isNull(oldIndex) ? new MPJAbstractWrapper.Node(clazz, this.tableIndex, ROOT_NODE) : new MPJAbstractWrapper.Node(clazz, this.tableIndex, this.node);
        MPJLambdaWrapper<T> instance = this.instance(newIndex, keyWord, clazz, n);
        this.node = n;
        this.onWrappers.add(instance);
        if (StringUtils.isBlank((CharSequence)tableAlias)) {
            this.tableList.add(clazz, newIndex, false, ConfigProperties.tableAlias);
            instance.alias = ConfigProperties.tableAlias;
            instance.hasAlias = false;
            ++this.tableIndex;
        } else {
            this.tableList.add(clazz, null, true, tableAlias);
            instance.alias = tableAlias;
            instance.hasAlias = true;
        }
        this.index = newIndex;
        consumer.accept((MPJAbstractLambdaWrapper<MPJLambdaWrapper<T>, ?>)instance, (MPJLambdaWrapper<MPJLambdaWrapper<T>>)this.typedThis);
        this.index = oldIndex;
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            MPJLambdaWrapper<T> wrapper = new MPJLambdaWrapper<T>();
            wrapper.from.setStringValue(joinSql);
            wrapper.keyWord = " " + keyWord + " ";
            this.onWrappers.add(wrapper);
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public List<Select> getSelectColumns() {
        return this.selectColumns;
    }

    public List<MybatisLabel<?, ?>> getResultMapMybatisLabel() {
        return this.resultMapMybatisLabel;
    }

    public String getKeyWord() {
        return this.keyWord;
    }
}

