/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.MPJAbstractWrapper;
import com.github.yulichang.wrapper.segments.Select;
import com.github.yulichang.wrapper.segments.SelectCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MPJAbstractLambdaWrapper<T, Children extends MPJAbstractLambdaWrapper<T, Children>>
extends MPJAbstractWrapper<T, Children> {
    protected String alias = ConfigProperties.tableAlias;
    protected boolean resultMap = false;
    protected int tableIndex = 1;
    protected TableList tableList;

    @Override
    protected <X> String columnToString(String index, int node, X column, boolean isJoin, Class<?> parent) {
        return this.columnToString(index, node, (SFunction)column, isJoin, parent);
    }

    @Override
    @SafeVarargs
    protected final <X> String columnsToString(String index, int node, boolean isJoin, Class<?> parent, X ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString(index, node, (SFunction)i, isJoin, parent)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(String index, int node, SFunction<?, ?> column, boolean isJoin, Class<?> parent) {
        Class<?> entityClass = LambdaUtils.getEntityClass(column);
        return this.getDefault(index, node, entityClass, isJoin, parent) + "." + this.getCache(column).getTagColumn();
    }

    protected SelectCache getCache(SFunction<?, ?> fn) {
        Class<?> aClass = LambdaUtils.getEntityClass(fn);
        Map<String, SelectCache> cacheMap = ColumnCache.getMapField(aClass);
        return cacheMap.get(LambdaUtils.getName(fn));
    }

    protected String getDefault(String index, int node, Class<?> clazz, boolean isJoin, Class<?> parent) {
        if (Objects.isNull(index)) {
            if (!isJoin && Objects.equals(clazz, this.getEntityClass())) {
                return this.alias;
            }
            Table table = this.tableList.getPositive(clazz);
            return table.hasAlias ? table.alias : table.alias + (Objects.isNull(table.index) ? "" : table.index);
        }
        Table table = this.tableList.get(clazz, index);
        if (table.hasAlias) {
            return table.alias;
        }
        if (Objects.nonNull(table.getIndex())) {
            if (isJoin && (Objects.equals(clazz, this.getEntityClass()) || Objects.equals(parent, clazz))) {
                if (node == -1) {
                    return table.alias;
                }
                if (node == 0) {
                    Table t = this.tableList.getOrElse(clazz, index);
                    if (Objects.isNull(t.getIndex())) {
                        return t.alias;
                    }
                    return t.alias + t.getIndex();
                }
                return table.alias + node;
            }
            return table.alias + table.getIndex();
        }
        return table.alias;
    }

    protected String getDefaultSelect(String index, Class<?> clazz, Select s) {
        if (s.isLabel()) {
            if (Objects.nonNull(s.getIndex())) {
                return s.getIndex();
            }
            Table table = this.tableList.get(s.getClazz());
            return Objects.isNull(table.index) ? "" : table.index;
        }
        if (Objects.isNull(index)) {
            if (Objects.equals(clazz, this.getEntityClass())) {
                return "";
            }
            Table table = this.tableList.getPositive(clazz);
            return Objects.isNull(table.index) ? "" : table.index;
        }
        Table table = this.tableList.get(clazz, index);
        if (Objects.nonNull(table.getIndex())) {
            return table.getIndex();
        }
        return "";
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
        this.node = ROOT_NODE;
        this.tableList = new TableList(this.getEntityClass(), null, this.alias);
    }

    public boolean isResultMap() {
        return this.resultMap;
    }

    public static class Table {
        private final Class<?> clazz;
        private final String index;
        private boolean hasAlias;
        private final String alias;

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getIndex() {
            return this.index;
        }

        public boolean isHasAlias() {
            return this.hasAlias;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setHasAlias(boolean hasAlias) {
            this.hasAlias = hasAlias;
        }

        public String toString() {
            return "MPJAbstractLambdaWrapper.Table(clazz=" + this.getClazz() + ", index=" + this.getIndex() + ", hasAlias=" + this.isHasAlias() + ", alias=" + this.getAlias() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Table)) {
                return false;
            }
            Table other = (Table)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasAlias() != other.isHasAlias()) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$index = this.getIndex();
            String other$index = other.getIndex();
            if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Table;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasAlias() ? 79 : 97);
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : $index.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        public Table(Class<?> clazz, String index, boolean hasAlias, String alias) {
            this.clazz = clazz;
            this.index = index;
            this.hasAlias = hasAlias;
            this.alias = alias;
        }
    }

    public static class TableList {
        private final Table DEFAULT_TABLE;
        private final List<Table> list = new ArrayList<Table>();

        public TableList(Class<?> clazz, String index, String alias) {
            this.DEFAULT_TABLE = new Table(clazz, index, false, alias);
        }

        public void add(Class<?> clazz, String index, boolean hasAlias, String alias) {
            this.list.add(new Table(clazz, index, hasAlias, alias));
        }

        public Table get(Class<?> clazz) {
            if (this.list.isEmpty()) {
                return this.DEFAULT_TABLE;
            }
            for (int i = this.list.size() - 1; i >= 0; --i) {
                Table t = this.list.get(i);
                if (clazz != t.clazz) continue;
                return t;
            }
            return this.DEFAULT_TABLE;
        }

        public Table get(Class<?> clazz, String index) {
            if (Objects.isNull(index)) {
                return this.get(clazz);
            }
            if (this.list.isEmpty()) {
                return this.DEFAULT_TABLE;
            }
            for (int i = this.list.size() - 1; i >= 0; --i) {
                Table t = this.list.get(i);
                if (clazz != t.clazz || !Objects.equals(index, t.getIndex())) continue;
                return t;
            }
            return this.get(clazz);
        }

        public Table getPositive(Class<?> clazz, String index) {
            if (Objects.isNull(index)) {
                return this.get(clazz);
            }
            if (this.list.isEmpty()) {
                return this.DEFAULT_TABLE;
            }
            for (Table t : this.list) {
                if (clazz != t.clazz || !Objects.equals(index, t.getIndex())) continue;
                return t;
            }
            return this.getPositive(clazz);
        }

        public Table getPositive(Class<?> clazz) {
            if (this.list.isEmpty()) {
                return this.DEFAULT_TABLE;
            }
            for (Table t : this.list) {
                if (clazz != t.clazz) continue;
                return t;
            }
            return this.DEFAULT_TABLE;
        }

        public Stream<Table> stream() {
            return this.list.stream();
        }

        public void clear() {
            this.list.clear();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Table getOrElse(Class<?> clazz, String index) {
            if (Objects.isNull(index)) {
                return this.get(clazz);
            }
            for (int i = this.list.size() - 1; i >= 0; --i) {
                Table t = this.list.get(i);
                if (clazz != t.clazz || Objects.equals(index, t.getIndex()) || Integer.parseInt(t.getIndex()) >= Integer.parseInt(index)) continue;
                return t;
            }
            return this.DEFAULT_TABLE;
        }
    }
}

