/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class LogicInfoUtils
implements Constants {
    private static final Map<Class<?>, Map<String, String>> LOGIC_CACHE = new ConcurrentHashMap();

    public static String getLogicInfo(String tableIndex, Class<?> clazz, boolean hasAlias, String alias) {
        Map<String, String> absent = LOGIC_CACHE.get(clazz);
        if (absent == null) {
            absent = new ConcurrentHashMap<String, String>();
            LOGIC_CACHE.put(clazz, absent);
        }
        return absent.computeIfAbsent(hasAlias ? alias : alias + tableIndex, key -> LogicInfoUtils.getLogicStr(key, clazz));
    }

    private static String getLogicStr(String prefix, Class<?> clazz) {
        String value;
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)tableInfo, (String)"table not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
        String logicStr = tableInfo.isWithLogicDelete() && Objects.nonNull(tableInfo.getLogicDeleteFieldInfo()) ? ("null".equalsIgnoreCase(value = tableInfo.getLogicDeleteFieldInfo().getLogicNotDeleteValue()) ? " AND " + prefix + "." + tableInfo.getLogicDeleteFieldInfo().getColumn() + " IS NULL" : " AND " + prefix + "." + tableInfo.getLogicDeleteFieldInfo().getColumn() + "=" + String.format(tableInfo.getLogicDeleteFieldInfo().isCharSequence() ? "'%s'" : "%s", value)) : "";
        return logicStr;
    }
}

