/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave.video;

import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.IgnoreErrorEncoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.audio.AudioAttributes;
import it.sauronsoftware.jave.enumers.VideoMergeTypeEnum;
import it.sauronsoftware.jave.video.VideoAttributes;
import java.io.File;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class VideoUtils {
    public static void thumbnailByOneFramePerSecond(File source, File imageTargetPath) {
        VideoUtils.thumbnail(source, imageTargetPath, 1, null, null, null, "2");
    }

    public static void thumbnailByOneFrameEveryFiveSeconds(File source, File imageTargetPath) {
        VideoUtils.thumbnail(source, imageTargetPath, 1, 5.0, null, null, null);
    }

    public static void thumbnailByOneFrameEveryFiveSecondsAndStartTime(File source, File imageTargetPath, String startTime, String duration) {
        VideoUtils.thumbnail(source, imageTargetPath, 1, 5.0, startTime, duration, null);
    }

    public static void thumbnail(File source, File imageTargetPath, Integer frameRate, Double intervalTime, String startTime, String duration, String qv) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        VideoAttributes video = new VideoAttributes();
        if (frameRate != null && intervalTime == null) {
            video.setFrameRate(frameRate);
        }
        if (frameRate != null && intervalTime != null) {
            String fps = "fps=" + frameRate + "/" + intervalTime;
            video.setVf(fps);
        }
        if (startTime != null) {
            video.setStartTime(startTime);
        }
        if (duration != null) {
            video.setDuration(duration);
        }
        if (qv != null && qv.length() > 0) {
            video.setQv(qv);
        }
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat("image2");
        attrs.setVideoAttributes(video);
        try {
            encoder.encode(source, imageTargetPath, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void getVoideoAudio(File source, File target, EncodingAttributes attrs) {
        if (attrs == null) {
            VideoUtils.getVoideoAudioToWav(source, target);
            return;
        }
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        try {
            encoder.encode(source, target, attrs);
        }
        catch (EncoderException e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void getVoideoAudioToWav(File source, File target) {
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("pcm_s16le");
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat("wav");
        attrs.setAudioAttributes(audio);
        attrs.setVideoAttributes(new VideoAttributes());
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        try {
            encoder.encode(source, target, attrs);
        }
        catch (EncoderException e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void mergeVideoByLossless(File source, File target, String format) {
        String fileName = source.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (StringUtils.isEmpty((CharSequence)suffix) || !"txt".equalsIgnoreCase(suffix)) {
            throw new RuntimeException("\u8bf7\u5c06\u6587\u4ef6\u540d\u6309\u683c\u5f0f\u4fdd\u5b58\u5230txt\u6587\u4ef6\u4e2d");
        }
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        EncodingAttributes attrs = new EncodingAttributes();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{format})) {
            attrs.setFormat(format);
        } else {
            attrs.setFormat(format);
        }
        VideoAttributes video = new VideoAttributes();
        video.setCodec("copy");
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("copy");
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encodeMergeVideoByLossless(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void mergeVideoByDamaging(LinkedList<File> source, File target, String format) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        EncodingAttributes attrs = new EncodingAttributes();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{format})) {
            attrs.setFormat(format);
        } else {
            attrs.setFormat(format);
        }
        VideoAttributes video = new VideoAttributes();
        video.setCodec("h264");
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("libmp3lame");
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encodeMergeVideoByDamaging(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void mergeVoideoAndAudioByInsert(LinkedList<File> source, File target, String format) {
        if (source == null || source.size() != 2) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u8981\u5408\u5e76\u7684\u6587\u4ef6");
        }
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        EncodingAttributes attrs = new EncodingAttributes();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{format})) {
            attrs.setFormat(format);
        } else {
            attrs.setFormat(format);
        }
        VideoAttributes video = new VideoAttributes();
        video.setMergeType(VideoMergeTypeEnum.INSERT);
        video.setCodec("copy");
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("aac");
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encodeMergeVideoAndAudio(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void mergeVoideoAndAudioByReplace(LinkedList<File> source, File target, String format) {
        if (source == null || source.size() != 2) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u8981\u5408\u5e76\u7684\u6587\u4ef6");
        }
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        EncodingAttributes attrs = new EncodingAttributes();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{format})) {
            attrs.setFormat(format);
        } else {
            attrs.setFormat(format);
        }
        VideoAttributes video = new VideoAttributes();
        video.setMergeType(VideoMergeTypeEnum.REPLACE);
        video.setCodec("copy");
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("aac");
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encodeMergeVideoAndAudio(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void roateVideo(File source, File target, String vf) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        VideoAttributes video = new VideoAttributes();
        if (vf != null && vf.length() > 0) {
            video.setVf(vf);
        }
        AudioAttributes audio = new AudioAttributes();
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void roateVideoByMetadata(File source, File target, String rotate) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        VideoAttributes video = new VideoAttributes();
        video.setCodec("copy");
        AudioAttributes audio = new AudioAttributes();
        audio.setCodec("copy");
        EncodingAttributes attrs = new EncodingAttributes();
        if (rotate != null && rotate.length() > 0) {
            attrs.setMetadataSv(rotate);
        }
        attrs.setVideoAttributes(video);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void webm2mp4(File source, File target, String bv, String bufsize, String maxrate) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        VideoAttributes video = new VideoAttributes();
        video.setBv("2000k");
        video.setBufsize("2000k");
        video.setMaxrate("2500k");
        if (bv != null && bv.length() > 0) {
            video.setBv(bv);
        }
        if (bufsize != null && bufsize.length() > 0) {
            video.setBufsize(bufsize);
        }
        if (maxrate != null && maxrate.length() > 0) {
            video.setMaxrate(maxrate);
        }
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setVideoAttributes(video);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static void webm2mp4(File source, File target, String fflags, Integer frameRate) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        VideoAttributes video = new VideoAttributes();
        video.setFrameRate(24);
        if (frameRate != null) {
            video.setFrameRate(frameRate);
        }
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFflags("+genpts");
        attrs.setVideoAttributes(video);
        if (fflags != null && fflags.length() > 0) {
            attrs.setFflags(fflags);
        }
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("error: ", e);
        }
    }

    public static MultimediaInfo getVideoInfo(File source) {
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        MultimediaInfo info = null;
        try {
            info = encoder.getInfo(source);
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        return info;
    }
}

