/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.x11;

import com.sun.jna.platform.unix.X11;
import com.tulskiy.keymaster.common.MediaKey;
import java.util.HashMap;
import javax.swing.KeyStroke;

class KeyMap {
    private static final HashMap<Integer, Integer> common = new HashMap<Integer, Integer>(){
        {
            this.put(27, 65307);
            this.put(8, 65288);
            this.put(9, 65289);
            this.put(10, 65293);
            this.put(19, 65299);
            this.put(145, 65300);
            this.put(127, 65535);
            this.put(12, 65291);
            this.put(36, 65360);
            this.put(37, 65361);
            this.put(38, 65362);
            this.put(39, 65363);
            this.put(40, 65364);
            this.put(33, 65365);
            this.put(34, 65366);
            this.put(35, 65367);
            this.put(65368, 65368);
            this.put(225, 65433);
            this.put(224, 65431);
            this.put(226, 65430);
            this.put(227, 65432);
            this.put(32, 32);
            this.put(517, 33);
            this.put(152, 34);
            this.put(520, 35);
            this.put(515, 36);
            this.put(150, 38);
            this.put(519, 40);
            this.put(522, 41);
            this.put(151, 42);
            this.put(521, 43);
            this.put(44, 44);
            this.put(45, 45);
            this.put(46, 46);
            this.put(47, 47);
            this.put(513, 58);
            this.put(59, 59);
            this.put(153, 60);
            this.put(61, 61);
            this.put(160, 62);
            this.put(512, 64);
            this.put(161, 123);
            this.put(162, 125);
            this.put(92, 92);
            this.put(514, 94);
            this.put(523, 95);
            this.put(192, 96);
            this.put(111, 65455);
            this.put(106, 65450);
            this.put(155, 65379);
            this.put(107, 65451);
            this.put(109, 65453);
            this.put(65368, 65437);
            this.put(154, 65377);
            this.put(269025047, 269025047);
            this.put(269025044, 269025044);
            this.put(269025046, 269025046);
            this.put(269025045, 269025045);
        }
    };

    KeyMap() {
    }

    static byte getCode(KeyStroke keyStroke, X11.Display display) {
        int code = keyStroke.getKeyCode();
        int ret = -1;
        if (code >= 48 && code <= 57 || code >= 65 && code <= 90) {
            ret = code;
        } else if (code >= 112 && code <= 123) {
            ret = code - -65358;
        } else if (code >= 96 && code <= 105) {
            ret = code - -65360;
        } else {
            Integer i = common.get(code);
            if (i != null) {
                ret = i;
            }
        }
        if (ret != -1) {
            return X11.INSTANCE.XKeysymToKeycode(display, new X11.KeySym((long)ret));
        }
        return 0;
    }

    static byte getMediaCode(MediaKey mediaKey, X11.Display display) {
        int code = 0;
        switch (mediaKey) {
            case MEDIA_NEXT_TRACK: {
                code = 269025047;
                break;
            }
            case MEDIA_PLAY_PAUSE: {
                code = 269025044;
                break;
            }
            case MEDIA_PREV_TRACK: {
                code = 269025046;
                break;
            }
            case MEDIA_STOP: {
                code = 269025045;
            }
        }
        return X11.INSTANCE.XKeysymToKeycode(display, new X11.KeySym((long)code));
    }

    static int getModifiers(KeyStroke keyCode) {
        int modifiers = 0;
        if ((keyCode.getModifiers() & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((keyCode.getModifiers() & 0x80) != 0) {
            modifiers |= 4;
        }
        if ((keyCode.getModifiers() & 0x100) != 0) {
            modifiers |= 0x40;
        }
        if ((keyCode.getModifiers() & 0x200) != 0) {
            modifiers |= 8;
        }
        return modifiers;
    }
}

