/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.common;

import com.sun.jna.Platform;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.osx.CarbonProvider;
import com.tulskiy.keymaster.windows.WindowsProvider;
import com.tulskiy.keymaster.x11.X11Provider;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Provider
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
    private boolean useSwingEventQueue;
    private ExecutorService eventQueue;

    public static Provider getCurrentProvider(boolean useSwingEventQueue) {
        Provider provider;
        if (Platform.isX11()) {
            provider = new X11Provider();
        } else if (Platform.isWindows()) {
            provider = new WindowsProvider();
        } else if (Platform.isMac()) {
            provider = new CarbonProvider();
        } else {
            LOGGER.warn("No suitable provider for " + System.getProperty("os.name"));
            return null;
        }
        provider.setUseSwingEventQueue(useSwingEventQueue);
        provider.init();
        return provider;
    }

    protected abstract void init();

    public void stop() {
        if (this.eventQueue != null) {
            this.eventQueue.shutdown();
        }
    }

    public abstract void reset();

    @Override
    public void close() {
        this.reset();
        this.stop();
    }

    public abstract void register(KeyStroke var1, HotKeyListener var2);

    public abstract void register(MediaKey var1, HotKeyListener var2);

    public abstract void unregister(KeyStroke var1);

    public abstract void unregister(MediaKey var1);

    protected void fireEvent(HotKey hotKey) {
        HotKeyEvent event = new HotKeyEvent(hotKey);
        if (this.useSwingEventQueue) {
            SwingUtilities.invokeLater(event);
        } else {
            if (this.eventQueue == null) {
                this.eventQueue = Executors.newSingleThreadExecutor();
            }
            this.eventQueue.execute(event);
        }
    }

    public void setUseSwingEventQueue(boolean useSwingEventQueue) {
        this.useSwingEventQueue = useSwingEventQueue;
    }

    static {
        System.setProperty("jna.nosys", "true");
    }

    private class HotKeyEvent
    implements Runnable {
        private HotKey hotKey;

        private HotKeyEvent(HotKey hotKey) {
            this.hotKey = hotKey;
        }

        @Override
        public void run() {
            this.hotKey.listener.onHotKey(this.hotKey);
        }
    }
}

