/*
 * Decompiled with CFR 0.152.
 */
package goja;

import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.util.Hashtable;

public class QRCodeFormat {
    private int size = 256;
    private String encode = "UTF-8";
    private ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.M;
    private Color foreGroundColor = Color.BLACK;
    private Color backGroundColor = Color.WHITE;
    private String imageFormat = "png";
    private int margin = 0;
    private Hashtable<EncodeHintType, Object> hints = new Hashtable();

    public static QRCodeFormat NEW() {
        return new QRCodeFormat();
    }

    private QRCodeFormat() {
    }

    public int getSize() {
        return this.size;
    }

    public QRCodeFormat setSize(int size) {
        this.size = size;
        return this;
    }

    public String getEncode() {
        return this.encode;
    }

    public QRCodeFormat setEncode(String encode) {
        this.encode = encode;
        return this;
    }

    public ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public QRCodeFormat setErrorCorrectionLevel(char errorCorrectionLevel) {
        switch (Character.toUpperCase(errorCorrectionLevel)) {
            case 'L': {
                this.errorCorrectionLevel = ErrorCorrectionLevel.L;
                break;
            }
            case 'M': {
                this.errorCorrectionLevel = ErrorCorrectionLevel.M;
                break;
            }
            case 'Q': {
                this.errorCorrectionLevel = ErrorCorrectionLevel.Q;
                break;
            }
            case 'H': {
                this.errorCorrectionLevel = ErrorCorrectionLevel.H;
                break;
            }
            default: {
                this.errorCorrectionLevel = ErrorCorrectionLevel.M;
            }
        }
        return this;
    }

    public Color getForeGroundColor() {
        return this.foreGroundColor;
    }

    public QRCodeFormat setForeGroundColor(String foreGroundColor) {
        try {
            this.foreGroundColor = this.getColor(foreGroundColor);
        }
        catch (NumberFormatException e) {
            this.foreGroundColor = Color.BLACK;
        }
        return this;
    }

    public QRCodeFormat setForeGroundColor(Color foreGroundColor) {
        this.foreGroundColor = foreGroundColor;
        return this;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public QRCodeFormat setBackGroundColor(String backGroundColor) {
        try {
            this.backGroundColor = this.getColor(backGroundColor);
        }
        catch (NumberFormatException e) {
            this.backGroundColor = Color.WHITE;
        }
        return this;
    }

    public QRCodeFormat setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
        return this;
    }

    public String getImageFormat() {
        return this.imageFormat.toUpperCase();
    }

    public QRCodeFormat setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
        return this;
    }

    public int getMargin() {
        return this.margin;
    }

    public QRCodeFormat setMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public Hashtable<EncodeHintType, ?> getHints() {
        this.hints.clear();
        this.hints.put(EncodeHintType.ERROR_CORRECTION, this.getErrorCorrectionLevel());
        this.hints.put(EncodeHintType.CHARACTER_SET, this.getEncode());
        this.hints.put(EncodeHintType.MARGIN, this.getMargin());
        return this.hints;
    }

    private Color getColor(String hexString) {
        if (hexString.charAt(0) == '#') {
            return new Color(Long.decode(hexString).intValue());
        }
        return new Color(Long.decode("0xFF" + hexString).intValue());
    }
}

