/*
 * Decompiled with CFR 0.152.
 */
package goja;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import goja.QRCodeFormat;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;

public final class QRCode {
    private QRCodeFormat format = null;
    private BufferedImage qrcodeImage = null;
    private File qrcodeFile = null;

    public BufferedImage getQrcodeImage() {
        return this.qrcodeImage;
    }

    public File getQrcodeFile() {
        return this.qrcodeFile;
    }

    private QRCode() {
    }

    public static QRCode create(String content) {
        return QRCode.create(content, QRCodeFormat.NEW());
    }

    public static QRCode create(String content, QRCodeFormat format) {
        QRCode qrcode = new QRCode();
        qrcode.format = format;
        qrcode.qrcodeImage = QRCode.toQRCode(content, format);
        return qrcode;
    }

    public QRCode toFile(String f) {
        return this.toFile(new File(f));
    }

    public QRCode toFile(File qrcodeFile) {
        try {
            if (!qrcodeFile.exists()) {
                Files.createParentDirs((File)qrcodeFile);
                qrcodeFile.createNewFile();
            }
            if (!ImageIO.write((RenderedImage)this.qrcodeImage, this.getSuffixName(qrcodeFile), qrcodeFile)) {
                throw new RuntimeException();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.qrcodeFile = qrcodeFile;
        return this;
    }

    public QRCode toFile(String qrcodeFile, String appendFile) {
        return this.toFile(new File(qrcodeFile), new File(appendFile));
    }

    public QRCode toFile(File qrcodeFile, File appendFile) {
        try {
            if (!qrcodeFile.exists()) {
                Files.createParentDirs((File)qrcodeFile);
                qrcodeFile.createNewFile();
            }
            this.appendImage(this.qrcodeImage, ImageIO.read(appendFile), this.format);
            if (!ImageIO.write((RenderedImage)this.qrcodeImage, this.getSuffixName(qrcodeFile), qrcodeFile)) {
                throw new RuntimeException("Unexpected error writing image");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.qrcodeFile = qrcodeFile;
        return this;
    }

    private void appendImage(BufferedImage baseImage, BufferedImage appendImage, QRCodeFormat format) {
        Graphics gc = baseImage.getGraphics();
        gc.drawImage(appendImage, (baseImage.getWidth() - appendImage.getWidth()) / 2, (baseImage.getHeight() - appendImage.getHeight()) / 2, appendImage.getWidth(), appendImage.getHeight(), format.getBackGroundColor(), null);
    }

    public static BufferedImage toQRCode(String content) {
        return QRCode.toQRCode(content, null);
    }

    public static BufferedImage toQRCode(String content, QRCodeFormat format) {
        BitMatrix matrix;
        if (format == null) {
            format = QRCodeFormat.NEW();
        }
        content = new String(content.getBytes(Charset.forName(format.getEncode())));
        try {
            matrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, format.getSize(), format.getSize(), format.getHints());
        }
        catch (WriterException e) {
            throw new RuntimeException(e);
        }
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int fgColor = format.getForeGroundColor().getRGB();
        int bgColor = format.getBackGroundColor().getRGB();
        BufferedImage image = new BufferedImage(width, height, 5);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? fgColor : bgColor);
            }
        }
        return image;
    }

    public static String from(String qrcodeFile) {
        if (qrcodeFile.startsWith("http://") || qrcodeFile.startsWith("https://")) {
            try {
                return QRCode.from(new URL(qrcodeFile));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return QRCode.from(new File(qrcodeFile));
    }

    public static String from(File qrcodeFile) {
        if (!qrcodeFile.exists()) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(qrcodeFile);
            return QRCode.from(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String from(URL qrcodeUrl) {
        try {
            BufferedImage image = ImageIO.read(qrcodeUrl);
            return QRCode.from(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String from(BufferedImage qrcodeImage) {
        String content;
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(qrcodeImage);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        try {
            Result result = new QRCodeReader().decode(bitmap);
            content = result.getText();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ChecksumException e) {
            throw new RuntimeException(e);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    private String getSuffixName(File file) {
        String path = file.getAbsolutePath();
        if (Strings.isNullOrEmpty((String)path)) {
            return this.format.getImageFormat();
        }
        int pos = path.lastIndexOf(46);
        if (-1 == pos) {
            return this.format.getImageFormat();
        }
        return path.substring(pos + 1).toUpperCase();
    }
}

