/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.model;

import com.power.common.constants.BaseErrorCode;
import com.power.common.interfaces.IMessage;
import com.power.common.model.BaseResult;
import com.power.common.util.DateTimeUtil;
import java.io.Serializable;

public class CommonResult<T>
extends BaseResult
implements Serializable {
    private static final long serialVersionUID = -7268040542410707954L;

    public CommonResult() {
    }

    public CommonResult(boolean success, String message) {
        this.setSuccess(success);
        this.setMessage(message);
    }

    public CommonResult(boolean success) {
        this.setSuccess(success);
    }

    public CommonResult(String code, String message) {
        this.setCode(code);
        this.setMessage(message);
    }

    public CommonResult(boolean success, String message, T data) {
        this.setSuccess(success);
        this.setMessage(message);
        this.setData(data);
    }

    public static CommonResult ok() {
        return CommonResult.ok(BaseErrorCode.Common.SUCCESS);
    }

    public static <T> CommonResult<T> ok(IMessage message) {
        return CommonResult.baseCreate(message.getCode(), message.getMessage(), true);
    }

    public static CommonResult fail() {
        return CommonResult.fail(BaseErrorCode.Common.UNKNOWN_ERROR);
    }

    public static CommonResult fail(IMessage message) {
        return CommonResult.fail(message.getCode(), message.getMessage());
    }

    public static CommonResult fail(String code, String message) {
        return CommonResult.baseCreate(code, message, false);
    }

    private static <T> CommonResult<T> baseCreate(String code, String msg, boolean success) {
        CommonResult<T> result = new CommonResult<T>();
        result.setCode(code);
        result.setSuccess(success);
        result.setMessage(msg);
        result.setTimestamp(DateTimeUtil.nowStrTime());
        return result;
    }

    public CommonResult<T> setResult(T data) {
        this.setData(data);
        return this;
    }

    @Override
    public T getData() {
        return super.getData();
    }
}

