/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.decorators;

import com.quaint.poster.core.abst.AbstractPosterDecorator;
import com.quaint.poster.core.abst.Poster;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import sun.font.FontDesignMetrics;

public class TextDecorator
extends AbstractPosterDecorator {
    private Font font = new Font(null);
    private int fontStyle = 0;
    private int fontSize = 16;
    private Color color = new Color(0, 0, 0);
    private String content;
    private boolean delLine = false;
    private boolean canNewLine = false;
    private int newLineLimit = 1;

    public TextDecorator(Poster poster) {
        super(poster);
    }

    public TextDecorator(Poster poster, int positionX, int positionY, int width, int height, Font font, int fontSize, Color color, String content, int fontStyle, boolean delLine, boolean canNewLine, int newLineLimit) {
        super(poster, positionX, positionY, width, height);
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
        this.content = content;
        this.fontStyle = fontStyle;
        this.delLine = delLine;
        this.canNewLine = canNewLine;
        this.newLineLimit = newLineLimit;
    }

    @Override
    public BufferedImage draw(BufferedImage image) {
        BufferedImage draw = this.poster.draw(image);
        return this.drawText(draw);
    }

    private BufferedImage drawText(BufferedImage image) {
        if (this.content == null || this.content.length() == 0) {
            return image;
        }
        this.font = this.font.deriveFont(this.fontStyle, this.fontSize);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        g.setColor(this.color);
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(this.font);
        if (this.canNewLine && this.width > this.fontSize) {
            this.width -= this.fontSize / 2;
            int charWidth = 0;
            int lineLimit = this.newLineLimit;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; lineLimit >= 0 && i < this.content.length(); ++i) {
                sb.append(this.content.charAt(i));
                if ((charWidth += ((FontMetrics)fm).charWidth(this.content.charAt(i))) > this.width * (this.newLineLimit - lineLimit + 1)) {
                    g.drawString(sb.toString(), this.positionX, this.positionY + this.fontSize + (this.newLineLimit - lineLimit) * this.fontSize);
                    sb.setLength(0);
                    --lineLimit;
                    continue;
                }
                if (charWidth > this.width * (this.newLineLimit + 1) - 2 * this.fontSize) {
                    sb.append("...");
                    g.drawString(sb.toString(), this.positionX, this.positionY + this.fontSize + (this.newLineLimit - lineLimit) * this.fontSize);
                    break;
                }
                if (i != this.content.length() - 1) continue;
                g.drawString(sb.toString(), this.positionX, this.positionY + this.fontSize + (this.newLineLimit - lineLimit) * this.fontSize);
            }
        } else {
            g.drawString(this.content, this.positionX, this.positionY + this.fontSize);
        }
        if (this.delLine && !this.canNewLine) {
            int delLineW = ((FontMetrics)fm).stringWidth(this.content);
            g.drawLine(this.positionX, this.positionY + 3 * this.fontSize / 5, this.positionX + delLineW, this.positionY + 3 * this.fontSize / 5);
        }
        g.dispose();
        return image;
    }

    public static TextDecoratorBuilder builder() {
        return new TextDecoratorBuilder();
    }

    public TextDecoratorBuilder toBuilder() {
        return new TextDecoratorBuilder().poster(this.poster).positionX(this.positionX).positionY(this.positionY).width(this.width).height(this.height).font(this.font).fontSize(this.fontSize).color(this.color).content(this.content).fontStyle(this.fontStyle).delLine(this.delLine).canNewLine(this.canNewLine).newLineLimit(this.newLineLimit);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextDecorator)) {
            return false;
        }
        TextDecorator other = (TextDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        if (this.getFontStyle() != other.getFontStyle()) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        if (this.isDelLine() != other.isDelLine()) {
            return false;
        }
        if (this.isCanNewLine() != other.isCanNewLine()) {
            return false;
        }
        return this.getNewLineLimit() == other.getNewLineLimit();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        result = result * 59 + this.getFontStyle();
        result = result * 59 + this.getFontSize();
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + (this.isDelLine() ? 79 : 97);
        result = result * 59 + (this.isCanNewLine() ? 79 : 97);
        result = result * 59 + this.getNewLineLimit();
        return result;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isDelLine() {
        return this.delLine;
    }

    public boolean isCanNewLine() {
        return this.canNewLine;
    }

    public int getNewLineLimit() {
        return this.newLineLimit;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDelLine(boolean delLine) {
        this.delLine = delLine;
    }

    public void setCanNewLine(boolean canNewLine) {
        this.canNewLine = canNewLine;
    }

    public void setNewLineLimit(int newLineLimit) {
        this.newLineLimit = newLineLimit;
    }

    @Override
    public String toString() {
        return "TextDecorator(font=" + this.getFont() + ", fontStyle=" + this.getFontStyle() + ", fontSize=" + this.getFontSize() + ", color=" + this.getColor() + ", content=" + this.getContent() + ", delLine=" + this.isDelLine() + ", canNewLine=" + this.isCanNewLine() + ", newLineLimit=" + this.getNewLineLimit() + ")";
    }

    public static class TextDecoratorBuilder {
        private Poster poster;
        private int positionX;
        private int positionY;
        private int width;
        private int height;
        private Font font;
        private int fontSize;
        private Color color;
        private String content;
        private int fontStyle;
        private boolean delLine;
        private boolean canNewLine;
        private int newLineLimit;

        TextDecoratorBuilder() {
        }

        public TextDecoratorBuilder poster(Poster poster) {
            this.poster = poster;
            return this;
        }

        public TextDecoratorBuilder positionX(int positionX) {
            this.positionX = positionX;
            return this;
        }

        public TextDecoratorBuilder positionY(int positionY) {
            this.positionY = positionY;
            return this;
        }

        public TextDecoratorBuilder width(int width) {
            this.width = width;
            return this;
        }

        public TextDecoratorBuilder height(int height) {
            this.height = height;
            return this;
        }

        public TextDecoratorBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public TextDecoratorBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public TextDecoratorBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public TextDecoratorBuilder content(String content) {
            this.content = content;
            return this;
        }

        public TextDecoratorBuilder fontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        public TextDecoratorBuilder delLine(boolean delLine) {
            this.delLine = delLine;
            return this;
        }

        public TextDecoratorBuilder canNewLine(boolean canNewLine) {
            this.canNewLine = canNewLine;
            return this;
        }

        public TextDecoratorBuilder newLineLimit(int newLineLimit) {
            this.newLineLimit = newLineLimit;
            return this;
        }

        public TextDecorator build() {
            return new TextDecorator(this.poster, this.positionX, this.positionY, this.width, this.height, this.font, this.fontSize, this.color, this.content, this.fontStyle, this.delLine, this.canNewLine, this.newLineLimit);
        }

        public String toString() {
            return "TextDecorator.TextDecoratorBuilder(poster=" + this.poster + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", width=" + this.width + ", height=" + this.height + ", font=" + this.font + ", fontSize=" + this.fontSize + ", color=" + this.color + ", content=" + this.content + ", fontStyle=" + this.fontStyle + ", delLine=" + this.delLine + ", canNewLine=" + this.canNewLine + ", newLineLimit=" + this.newLineLimit + ")";
        }
    }
}

