/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.decorators;

import com.quaint.poster.core.abst.AbstractPosterDecorator;
import com.quaint.poster.core.abst.Poster;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MergeImageDecorator
extends AbstractPosterDecorator {
    private List<BufferedImage> images;
    private int nextAddHeight;

    public MergeImageDecorator(Poster poster) {
        super(poster);
    }

    public MergeImageDecorator(Poster poster, int positionX, int positionY, int width, int height, List<BufferedImage> images) {
        super(poster, positionX, positionY, width, height);
        this.images = images;
    }

    @Override
    public BufferedImage draw(BufferedImage image) {
        BufferedImage draw = this.poster.draw(image);
        return this.margeImage(draw);
    }

    private BufferedImage margeImage(BufferedImage sourceImage) {
        AtomicInteger addPositionY = new AtomicInteger();
        Graphics2D g = sourceImage.createGraphics();
        this.images.forEach(image -> {
            g.drawImage((Image)image, this.positionX, this.positionY + addPositionY.get(), this.width, image.getHeight() * this.width / image.getWidth(), null);
            addPositionY.addAndGet(image.getHeight() * this.width / image.getWidth());
        });
        g.dispose();
        this.nextAddHeight = addPositionY.get() - this.height;
        return sourceImage;
    }

    public static MergeImageDecoratorBuilder builder() {
        return new MergeImageDecoratorBuilder();
    }

    public MergeImageDecoratorBuilder toBuilder() {
        return new MergeImageDecoratorBuilder().poster(this.poster).positionX(this.positionX).positionY(this.positionY).width(this.width).height(this.height).images(this.images);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeImageDecorator)) {
            return false;
        }
        MergeImageDecorator other = (MergeImageDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BufferedImage> this$images = this.getImages();
        List<BufferedImage> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        return this.getNextAddHeight() == other.getNextAddHeight();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MergeImageDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<BufferedImage> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        result = result * 59 + this.getNextAddHeight();
        return result;
    }

    public List<BufferedImage> getImages() {
        return this.images;
    }

    public int getNextAddHeight() {
        return this.nextAddHeight;
    }

    public void setImages(List<BufferedImage> images) {
        this.images = images;
    }

    public void setNextAddHeight(int nextAddHeight) {
        this.nextAddHeight = nextAddHeight;
    }

    @Override
    public String toString() {
        return "MergeImageDecorator(images=" + this.getImages() + ", nextAddHeight=" + this.getNextAddHeight() + ")";
    }

    public static class MergeImageDecoratorBuilder {
        private Poster poster;
        private int positionX;
        private int positionY;
        private int width;
        private int height;
        private List<BufferedImage> images;

        MergeImageDecoratorBuilder() {
        }

        public MergeImageDecoratorBuilder poster(Poster poster) {
            this.poster = poster;
            return this;
        }

        public MergeImageDecoratorBuilder positionX(int positionX) {
            this.positionX = positionX;
            return this;
        }

        public MergeImageDecoratorBuilder positionY(int positionY) {
            this.positionY = positionY;
            return this;
        }

        public MergeImageDecoratorBuilder width(int width) {
            this.width = width;
            return this;
        }

        public MergeImageDecoratorBuilder height(int height) {
            this.height = height;
            return this;
        }

        public MergeImageDecoratorBuilder images(List<BufferedImage> images) {
            this.images = images;
            return this;
        }

        public MergeImageDecorator build() {
            return new MergeImageDecorator(this.poster, this.positionX, this.positionY, this.width, this.height, this.images);
        }

        public String toString() {
            return "MergeImageDecorator.MergeImageDecoratorBuilder(poster=" + this.poster + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", width=" + this.width + ", height=" + this.height + ", images=" + this.images + ")";
        }
    }
}

