/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.decorators;

import com.quaint.poster.core.abst.AbstractPosterDecorator;
import com.quaint.poster.core.abst.Poster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import sun.font.FontDesignMetrics;

public class LabelTextDecorator
extends AbstractPosterDecorator {
    private Font font = new Font(null);
    private int fontStyle = 0;
    private int fontSize = 16;
    private Color color = new Color(255, 255, 255);
    private List<String> contentList;
    private BufferedImage tipBg;
    private int bgHeight;
    private int tipMargin;

    public LabelTextDecorator(Poster poster) {
        super(poster);
    }

    public LabelTextDecorator(Poster poster, int positionX, int positionY, int width, int height, Font font, int fontSize, Color color, List<String> contentList, int fontStyle, BufferedImage tipBg, int tipMargin, int bgHeight) {
        super(poster, positionX, positionY, width, height);
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
        this.contentList = contentList;
        this.fontStyle = fontStyle;
        this.tipBg = tipBg;
        this.tipMargin = tipMargin;
        this.bgHeight = bgHeight;
    }

    @Override
    public BufferedImage draw(BufferedImage image) {
        BufferedImage draw = this.poster.draw(image);
        return this.drawText(draw);
    }

    private BufferedImage drawText(BufferedImage image) {
        if (this.contentList == null || this.contentList.size() == 0 || this.tipBg == null) {
            return image;
        }
        this.font = this.font.deriveFont(this.fontStyle, this.fontSize);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setFont(this.font);
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(this.font.deriveFont(this.fontStyle, this.fontSize));
        AtomicInteger xAdd = new AtomicInteger(0);
        this.contentList.forEach(content -> {
            int strW = fm.stringWidth((String)content);
            int bgH = this.bgHeight == 0 ? this.tipBg.getHeight() : this.bgHeight;
            g.drawImage(this.tipBg, this.positionX + xAdd.get(), this.positionY, strW + this.fontSize, bgH, null);
            g.drawString((String)content, this.positionX + xAdd.get() + this.fontSize / 2, this.positionY + this.fontSize + (bgH - this.fontSize) * 2 / 5);
            xAdd.addAndGet(strW + this.tipMargin);
        });
        g.dispose();
        return image;
    }

    public static LabelTextDecoratorBuilder builder() {
        return new LabelTextDecoratorBuilder();
    }

    public LabelTextDecoratorBuilder toBuilder() {
        return new LabelTextDecoratorBuilder().poster(this.poster).positionX(this.positionX).positionY(this.positionY).width(this.width).height(this.height).font(this.font).fontSize(this.fontSize).color(this.color).contentList(this.contentList).fontStyle(this.fontStyle).tipBg(this.tipBg).tipMargin(this.tipMargin).bgHeight(this.bgHeight);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelTextDecorator)) {
            return false;
        }
        LabelTextDecorator other = (LabelTextDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        if (this.getFontStyle() != other.getFontStyle()) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        List<String> this$contentList = this.getContentList();
        List<String> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        BufferedImage this$tipBg = this.getTipBg();
        BufferedImage other$tipBg = other.getTipBg();
        if (this$tipBg == null ? other$tipBg != null : !this$tipBg.equals(other$tipBg)) {
            return false;
        }
        if (this.getBgHeight() != other.getBgHeight()) {
            return false;
        }
        return this.getTipMargin() == other.getTipMargin();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LabelTextDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        result = result * 59 + this.getFontStyle();
        result = result * 59 + this.getFontSize();
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        List<String> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        BufferedImage $tipBg = this.getTipBg();
        result = result * 59 + ($tipBg == null ? 43 : $tipBg.hashCode());
        result = result * 59 + this.getBgHeight();
        result = result * 59 + this.getTipMargin();
        return result;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public List<String> getContentList() {
        return this.contentList;
    }

    public BufferedImage getTipBg() {
        return this.tipBg;
    }

    public int getBgHeight() {
        return this.bgHeight;
    }

    public int getTipMargin() {
        return this.tipMargin;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setContentList(List<String> contentList) {
        this.contentList = contentList;
    }

    public void setTipBg(BufferedImage tipBg) {
        this.tipBg = tipBg;
    }

    public void setBgHeight(int bgHeight) {
        this.bgHeight = bgHeight;
    }

    public void setTipMargin(int tipMargin) {
        this.tipMargin = tipMargin;
    }

    @Override
    public String toString() {
        return "LabelTextDecorator(font=" + this.getFont() + ", fontStyle=" + this.getFontStyle() + ", fontSize=" + this.getFontSize() + ", color=" + this.getColor() + ", contentList=" + this.getContentList() + ", tipBg=" + this.getTipBg() + ", bgHeight=" + this.getBgHeight() + ", tipMargin=" + this.getTipMargin() + ")";
    }

    public static class LabelTextDecoratorBuilder {
        private Poster poster;
        private int positionX;
        private int positionY;
        private int width;
        private int height;
        private Font font;
        private int fontSize;
        private Color color;
        private List<String> contentList;
        private int fontStyle;
        private BufferedImage tipBg;
        private int tipMargin;
        private int bgHeight;

        LabelTextDecoratorBuilder() {
        }

        public LabelTextDecoratorBuilder poster(Poster poster) {
            this.poster = poster;
            return this;
        }

        public LabelTextDecoratorBuilder positionX(int positionX) {
            this.positionX = positionX;
            return this;
        }

        public LabelTextDecoratorBuilder positionY(int positionY) {
            this.positionY = positionY;
            return this;
        }

        public LabelTextDecoratorBuilder width(int width) {
            this.width = width;
            return this;
        }

        public LabelTextDecoratorBuilder height(int height) {
            this.height = height;
            return this;
        }

        public LabelTextDecoratorBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public LabelTextDecoratorBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public LabelTextDecoratorBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public LabelTextDecoratorBuilder contentList(List<String> contentList) {
            this.contentList = contentList;
            return this;
        }

        public LabelTextDecoratorBuilder fontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        public LabelTextDecoratorBuilder tipBg(BufferedImage tipBg) {
            this.tipBg = tipBg;
            return this;
        }

        public LabelTextDecoratorBuilder tipMargin(int tipMargin) {
            this.tipMargin = tipMargin;
            return this;
        }

        public LabelTextDecoratorBuilder bgHeight(int bgHeight) {
            this.bgHeight = bgHeight;
            return this;
        }

        public LabelTextDecorator build() {
            return new LabelTextDecorator(this.poster, this.positionX, this.positionY, this.width, this.height, this.font, this.fontSize, this.color, this.contentList, this.fontStyle, this.tipBg, this.tipMargin, this.bgHeight);
        }

        public String toString() {
            return "LabelTextDecorator.LabelTextDecoratorBuilder(poster=" + this.poster + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", width=" + this.width + ", height=" + this.height + ", font=" + this.font + ", fontSize=" + this.fontSize + ", color=" + this.color + ", contentList=" + this.contentList + ", fontStyle=" + this.fontStyle + ", tipBg=" + this.tipBg + ", tipMargin=" + this.tipMargin + ", bgHeight=" + this.bgHeight + ")";
        }
    }
}

