/*
 * Decompiled with CFR 0.152.
 */
package com.quaint.poster.core.decorators;

import com.quaint.poster.core.abst.AbstractPosterDecorator;
import com.quaint.poster.core.abst.Poster;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;

public class ImageDecorator
extends AbstractPosterDecorator {
    private BufferedImage image;
    private boolean circle;

    public ImageDecorator(Poster poster) {
        super(poster);
    }

    public ImageDecorator(Poster poster, int positionX, int positionY, int width, int height, BufferedImage image, boolean circle) {
        super(poster, positionX, positionY, width, height);
        this.image = image;
        this.circle = circle;
    }

    @Override
    public BufferedImage draw(BufferedImage image) {
        BufferedImage draw = this.poster.draw(image);
        return this.drawImage(draw);
    }

    private BufferedImage drawImage(BufferedImage sourceImage) {
        if (this.image == null) {
            return sourceImage;
        }
        if (this.width == 0 || this.height == 0) {
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        }
        Graphics2D g = sourceImage.createGraphics();
        if (this.circle) {
            Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, this.image.getWidth(), this.image.getHeight());
            BufferedImage output = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 6);
            Graphics2D g2 = output.createGraphics();
            output = g2.getDeviceConfiguration().createCompatibleImage(this.image.getWidth(), this.image.getHeight(), 3);
            g2 = output.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fill(new Rectangle(this.image.getWidth(), this.image.getHeight()));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setClip(shape);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage((Image)this.image, 0, 0, null);
            g2.dispose();
            this.image = output;
        }
        g.drawImage(this.image, this.positionX, this.positionY, this.width, this.height, null);
        g.dispose();
        return sourceImage;
    }

    public static ImageDecoratorBuilder builder() {
        return new ImageDecoratorBuilder();
    }

    public ImageDecoratorBuilder toBuilder() {
        return new ImageDecoratorBuilder().poster(this.poster).positionX(this.positionX).positionY(this.positionY).width(this.width).height(this.height).image(this.image).circle(this.circle);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageDecorator)) {
            return false;
        }
        ImageDecorator other = (ImageDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BufferedImage this$image = this.getImage();
        BufferedImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        return this.isCircle() == other.isCircle();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BufferedImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        result = result * 59 + (this.isCircle() ? 79 : 97);
        return result;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public boolean isCircle() {
        return this.circle;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setCircle(boolean circle) {
        this.circle = circle;
    }

    @Override
    public String toString() {
        return "ImageDecorator(image=" + this.getImage() + ", circle=" + this.isCircle() + ")";
    }

    public static class ImageDecoratorBuilder {
        private Poster poster;
        private int positionX;
        private int positionY;
        private int width;
        private int height;
        private BufferedImage image;
        private boolean circle;

        ImageDecoratorBuilder() {
        }

        public ImageDecoratorBuilder poster(Poster poster) {
            this.poster = poster;
            return this;
        }

        public ImageDecoratorBuilder positionX(int positionX) {
            this.positionX = positionX;
            return this;
        }

        public ImageDecoratorBuilder positionY(int positionY) {
            this.positionY = positionY;
            return this;
        }

        public ImageDecoratorBuilder width(int width) {
            this.width = width;
            return this;
        }

        public ImageDecoratorBuilder height(int height) {
            this.height = height;
            return this;
        }

        public ImageDecoratorBuilder image(BufferedImage image) {
            this.image = image;
            return this;
        }

        public ImageDecoratorBuilder circle(boolean circle) {
            this.circle = circle;
            return this;
        }

        public ImageDecorator build() {
            return new ImageDecorator(this.poster, this.positionX, this.positionY, this.width, this.height, this.image, this.circle);
        }

        public String toString() {
            return "ImageDecorator.ImageDecoratorBuilder(poster=" + this.poster + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", width=" + this.width + ", height=" + this.height + ", image=" + this.image + ", circle=" + this.circle + ")";
        }
    }
}

