/**
 * Oshi (https://github.com/oshi/oshi)
 *
 * Copyright (c) 2010 - 2017 The Oshi Project Team
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Maintainers:
 * dblock[at]dblock[dot]org
 * widdis[at]gmail[dot]com
 * enrico.bianchi[at]gmail[dot]com
 *
 * Contributors:
 * https://github.com/oshi/oshi/graphs/contributors
 */
package oshi.jna.platform.windows.COM;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WTypes.BSTR;
import com.sun.jna.platform.win32.WinNT.HRESULT;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.ptr.PointerByReference;

public class WbemServices extends Unknown {

    public WbemServices(Pointer pvInstance) {
        super(pvInstance);
    }

    public HRESULT ExecQuery(BSTR strQueryLanguage, BSTR strQuery, NativeLong lFlags, Pointer pCtx,
            PointerByReference ppEnum) {
        // ExecQuery is 21st method of vtable for WbemServices in WbemCli.h
        return (HRESULT) _invokeNativeObject(20,
                new Object[] { getPointer(), strQueryLanguage, strQuery, lFlags, pCtx, ppEnum }, HRESULT.class);
    }

    public HRESULT ExecMethod(BSTR strObjectPath, BSTR strMethodName, NativeLong lFlags, Pointer pCtx,
            Pointer pInParams, PointerByReference ppOutParams, PointerByReference ppCallResult) {
        // ExecMethod is 25th method of vtable for WbemServices in WbemCli.h
        return (HRESULT) _invokeNativeObject(24, new Object[] { getPointer(), strObjectPath, strMethodName, lFlags,
                pCtx, pInParams, ppOutParams, ppCallResult }, HRESULT.class);
    }
}